/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security.inheritance;

import io.quarkus.resteasy.reactive.server.test.security.inheritance.SubPaths;

public enum SecurityAnnotation {
    NONE(SubPaths.NO_SECURITY_ANNOTATION, false, null, false),
    METHOD_ROLES_ALLOWED(SubPaths.METHOD_ROLES_ALLOWED, false, "admin", false),
    METHOD_DENY_ALL(SubPaths.METHOD_DENY_ALL, true, null, false),
    METHOD_PERMIT_ALL(SubPaths.METHOD_PERMIT_ALL, false, null, false),
    CLASS_ROLES_ALLOWED(SubPaths.CLASS_ROLES_ALLOWED, false, "admin", true),
    CLASS_DENY_ALL(SubPaths.CLASS_DENY_ALL, true, null, true),
    CLASS_PERMIT_ALL(SubPaths.CLASS_PERMIT_ALL, false, null, true),
    CLASS_PERMIT_ALL_METHOD_PERMIT_ALL(SubPaths.CLASS_PERMIT_ALL_METHOD_PERMIT_ALL, false, null, true),
    CLASS_DENY_ALL_METHOD_ROLES_ALLOWED(SubPaths.CLASS_DENY_ALL_METHOD_ROLES_ALLOWED, false, "admin", true),
    CLASS_DENY_ALL_METHOD_PERMIT_ALL(SubPaths.CLASS_DENY_ALL_METHOD_PERMIT_ALL, false, null, true);

    static final String PATH_SEPARATOR = "/";
    private final SubPaths.SubPath subPath;
    private final String allowedRole;
    private final boolean isClassSecurityAnnotation;
    private final boolean denyAll;

    private SecurityAnnotation(SubPaths.SubPath subPath, boolean denyAll, String allowedRole, boolean isClassSecurityAnnotation) {
        this.subPath = subPath;
        this.denyAll = denyAll;
        this.allowedRole = allowedRole;
        this.isClassSecurityAnnotation = isClassSecurityAnnotation;
    }

    private String toSecurityAnnInfix(String classSecurityOn) {
        return this.isClassSecurityAnnotation ? classSecurityOn : "";
    }

    boolean hasSecurityAnnotation() {
        return this != NONE;
    }

    boolean denyAll() {
        return this.denyAll;
    }

    boolean endpointSecured() {
        return this.denyAll || this.allowedRole != null;
    }

    String assemblePath(String basePath, String classSecurityOn) {
        return this.subPath.classSubPathPrefix() + this.toSecurityAnnInfix(classSecurityOn) + basePath + this.subPath.methodSubPath();
    }

    String assemblePath(String basePath) {
        return this.subPath.classSubPathPrefix() + basePath + this.subPath.methodSubPath();
    }

    String assembleNotFoundPath(String basePath) {
        return this.subPath.classSubPathPrefix() + basePath;
    }

    String methodSubPath(String basePath, String classSecurityOn) {
        String path = this.assemblePath(basePath, classSecurityOn);
        return path.substring(path.indexOf(PATH_SEPARATOR, 1) + 1);
    }

    String methodSubPath(String basePath) {
        String path = this.assemblePath(basePath);
        return path.substring(path.indexOf(PATH_SEPARATOR, 1) + 1);
    }
}

