/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.simple;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import io.smallrye.common.annotation.Blocking;
import io.smallrye.common.annotation.NonBlocking;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Application;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ApplicationWithBlockingTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{BlockingApplication.class, ThreadNameResource.class});
        }
    });

    @Test
    public void test() {
        ((ValidatableResponse)RestAssured.get((String)"/tname/blocking", (Object[])new Object[0]).then()).body(Matchers.containsString((String)"executor"), new Matcher[]{Matchers.not((Matcher)Matchers.containsString((String)"loop"))});
        ((ValidatableResponse)RestAssured.get((String)"/tname/nonblocking", (Object[])new Object[0]).then()).body(Matchers.containsString((String)"loop"), new Matcher[]{Matchers.not((Matcher)Matchers.containsString((String)"executor"))});
        ((ValidatableResponse)RestAssured.get((String)"/tname2/blocking", (Object[])new Object[0]).then()).body(Matchers.containsString((String)"executor"), new Matcher[]{Matchers.not((Matcher)Matchers.containsString((String)"loop"))});
        ((ValidatableResponse)RestAssured.get((String)"/tname2/nonblocking", (Object[])new Object[0]).then()).body(Matchers.containsString((String)"loop"), new Matcher[]{Matchers.not((Matcher)Matchers.containsString((String)"executor"))});
    }

    @Blocking
    @Path(value="tname2")
    public static class ThreadNameResourceWithBlocking {
        @Path(value="blocking")
        @GET
        public String threadName() {
            return Thread.currentThread().getName();
        }

        @NonBlocking
        @Path(value="nonblocking")
        @GET
        public String nonBlocking() {
            return Thread.currentThread().getName();
        }
    }

    @Path(value="tname")
    public static class ThreadNameResource {
        @Path(value="blocking")
        @GET
        public String threadName() {
            return Thread.currentThread().getName();
        }

        @NonBlocking
        @Path(value="nonblocking")
        @GET
        public String nonBlocking() {
            return Thread.currentThread().getName();
        }
    }

    @Blocking
    public static class BlockingApplication
    extends Application {
    }
}

