/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.simple;

import io.quarkus.commons.classloading.ClassLoaderHelper;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;
import org.objectweb.asm.util.TraceMethodVisitor;

@Provider
public class IllegalClassExceptionMapper
implements ExceptionMapper<IncompatibleClassChangeError> {
    public Response toResponse(IncompatibleClassChangeError exception) {
        String message = exception.getMessage();
        Pattern pattern = Pattern.compile("Method (([a-zA-Z0-9_]+\\.)+)[a-zA-Z0-9_]+\\(.*");
        Matcher matcher = pattern.matcher(message);
        exception.printStackTrace();
        if (matcher.matches()) {
            String classname = matcher.group(1);
            classname = classname.substring(0, classname.length() - 1);
            System.err.println("IncompatibleClassChangeError for: " + classname + " dumping its bytecode:");
            this.dumpClass(classname, null);
            StackTraceElement stackTraceElement = exception.getStackTrace()[0];
            System.err.println("The call that triggered the error is at: " + stackTraceElement + " so dumping its bytecode:");
            this.dumpClass(stackTraceElement.getClassName(), stackTraceElement.getMethodName());
        }
        StringWriter writer = new StringWriter();
        exception.printStackTrace(new PrintWriter(writer));
        return Response.serverError().entity((Object)writer.toString()).build();
    }

    private void dumpClass(String classname, String method) {
        InputStream bytes = Thread.currentThread().getContextClassLoader().getResourceAsStream(ClassLoaderHelper.fromClassNameToResourceName((String)classname));
        try {
            ClassReader cr = new ClassReader(bytes);
            PrintWriter writer = new PrintWriter(System.err);
            if (method == null) {
                cr.accept((ClassVisitor)new TraceClassVisitor(writer), 0);
            } else {
                cr.accept((ClassVisitor)new MethodFindingClassVisitor(method, writer), 0);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static class MethodFindingClassVisitor
    extends ClassVisitor {
        private String method;
        private Textifier textifier;
        private PrintWriter writer;

        public MethodFindingClassVisitor(String method, PrintWriter writer) {
            super(589824);
            this.method = method;
            this.writer = writer;
            this.textifier = new Textifier();
        }

        public void visitEnd() {
            this.textifier.visitClassEnd();
            this.textifier.print(this.writer);
            this.writer.flush();
            super.visitEnd();
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
            if (this.method.equals(name)) {
                System.err.println("Match for method " + name + " " + descriptor);
                Textifier methodPrinter = this.textifier.visitMethod(access, name, descriptor, signature, exceptions);
                return new TraceMethodVisitor(mv, (Printer)methodPrinter);
            }
            return null;
        }
    }
}

