/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.simple;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import io.smallrye.common.annotation.Blocking;
import io.smallrye.common.annotation.NonBlocking;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.resteasy.reactive.server.core.BlockingOperationSupport;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class InterfaceWithImplTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addClasses(new Class[]{Greeting.class, GreetingImpl.class}));

    @Test
    public void test() {
        ((ValidatableResponse)RestAssured.get((String)"/hello/greeting/universe", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"name: universe / blocking: true"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)"/hello/greeting2/universe", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"name: universe / blocking: false"), new Matcher[0]);
    }

    @Path(value="/hello")
    @NonBlocking
    public static interface Greeting {
        @GET
        @Produces(value={"text/plain"})
        @Path(value="/greeting/{name}")
        public String greeting(String var1);

        @GET
        @Produces(value={"text/plain"})
        @Path(value="/greeting2/{name}")
        public String greeting2(String var1);
    }

    public static class GreetingImpl
    implements Greeting {
        @Override
        @Blocking
        public String greeting(String name) {
            return this.resultString(name);
        }

        @Override
        public String greeting2(String name) {
            return this.resultString(name);
        }

        private String resultString(String name) {
            return "name: " + name + " / blocking: " + BlockingOperationSupport.isBlockingAllowed();
        }
    }
}

