/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.simple;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class LocalDateCustomParamConverterProviderTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addClasses(new Class[]{HelloResource.class, CustomLocalDateParamConverterProvider.class, CustomLocalDateParamConverter.class}));

    @Test
    public void localDateAsQueryParam() {
        ((ValidatableResponse)RestAssured.get((String)"/hello?date=1981-W38-6", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"hello#1981-09-19"), new Matcher[0]);
    }

    @Test
    public void localDateAsPathParam() {
        ((ValidatableResponse)RestAssured.get((String)"/hello/1995-W38-4", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"hello@1995-09-21"), new Matcher[0]);
    }

    @Path(value="hello")
    public static class HelloResource {
        @GET
        public String helloQuery(@QueryParam(value="date") LocalDate date) {
            return "hello#" + date;
        }

        @GET
        @Path(value="{date}")
        public String helloPath(@PathParam(value="date") LocalDate date) {
            return "hello@" + date;
        }
    }

    @Provider
    public static class CustomLocalDateParamConverterProvider
    implements ParamConverterProvider {
        public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
            if (rawType == LocalDate.class) {
                return new CustomLocalDateParamConverter();
            }
            return null;
        }
    }

    public static class CustomLocalDateParamConverter
    implements ParamConverter<LocalDate> {
        public LocalDate fromString(String value) {
            return LocalDate.parse(value, DateTimeFormatter.ISO_WEEK_DATE);
        }

        public String toString(LocalDate value) {
            return value.format(DateTimeFormatter.ISO_WEEK_DATE);
        }
    }
}

