/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.simple;

import io.quarkus.resteasy.reactive.server.test.simple.MyParameter;
import io.quarkus.resteasy.reactive.server.test.simple.OtherBeanParam;
import io.quarkus.resteasy.reactive.server.test.simple.ParameterWithFromString;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import org.junit.jupiter.api.Assertions;

public class SimpleBeanParam {
    @QueryParam(value="query")
    String query;
    @QueryParam(value="query")
    private String privateQuery;
    @QueryParam(value="query")
    protected String protectedQuery;
    @QueryParam(value="query")
    public String publicQuery;
    @HeaderParam(value="header")
    String header;
    @Context
    UriInfo uriInfo;
    @BeanParam
    OtherBeanParam otherBeanParam;
    @QueryParam(value="queryList")
    List<String> queryList;
    @QueryParam(value="query")
    ParameterWithFromString parameterWithFromString;
    @QueryParam(value="missing")
    String missing;
    @DefaultValue(value="there")
    @QueryParam(value="missing")
    String missingWithDefaultValue;
    @QueryParam(value="missing")
    ParameterWithFromString missingParameterWithFromString;
    @DefaultValue(value="there")
    @QueryParam(value="missing")
    ParameterWithFromString missingParameterWithFromStringAndDefaultValue;
    @QueryParam(value="int")
    int primitiveParam;
    @QueryParam(value="missing")
    int missingPrimitiveParam;
    @DefaultValue(value="42")
    @QueryParam(value="missing")
    int missingPrimitiveParamWithDefaultValue;
    @QueryParam(value="query")
    MyParameter myParameter;
    @QueryParam(value="query")
    List<MyParameter> myParameterList;

    public void check(String path) {
        Assertions.assertEquals((Object)"one-query", (Object)this.query);
        Assertions.assertEquals((Object)"one-query", (Object)this.privateQuery);
        Assertions.assertEquals((Object)"one-query", (Object)this.protectedQuery);
        Assertions.assertEquals((Object)"one-query", (Object)this.publicQuery);
        Assertions.assertEquals((Object)"one-header", (Object)this.header);
        Assertions.assertNotNull((Object)this.uriInfo);
        Assertions.assertEquals((Object)path, (Object)this.uriInfo.getPath());
        Assertions.assertNotNull((Object)this.otherBeanParam);
        this.otherBeanParam.check(path);
        Assertions.assertNotNull(this.queryList);
        Assertions.assertEquals((Object)"one", (Object)this.queryList.get(0));
        Assertions.assertEquals((Object)"two", (Object)this.queryList.get(1));
        Assertions.assertNotNull((Object)this.parameterWithFromString);
        Assertions.assertEquals((Object)"ParameterWithFromString[val=one-query]", (Object)this.parameterWithFromString.toString());
        Assertions.assertNull((Object)this.missing);
        Assertions.assertEquals((Object)"there", (Object)this.missingWithDefaultValue);
        Assertions.assertNull((Object)this.missingParameterWithFromString);
        Assertions.assertEquals((Object)"ParameterWithFromString[val=there]", (Object)this.missingParameterWithFromStringAndDefaultValue.toString());
        Assertions.assertEquals((int)666, (int)this.primitiveParam);
        Assertions.assertEquals((int)0, (int)this.missingPrimitiveParam);
        Assertions.assertEquals((int)42, (int)this.missingPrimitiveParamWithDefaultValue);
        Assertions.assertEquals((Object)"one-queryone-query", (Object)this.myParameter.toString());
        Assertions.assertEquals((Object)"one-queryone-query", (Object)this.myParameterList.get(0).toString());
    }
}

