/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.stream;

import io.quarkus.resteasy.reactive.server.test.stream.StreamResource;
import io.quarkus.test.QuarkusUnitTest;
import io.quarkus.test.common.http.TestHTTPResource;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.subscription.Cancellable;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.sse.SseEventSource;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.resteasy.reactive.client.impl.MultiInvoker;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.RegisterExtension;

@DisabledOnOs(value={OS.WINDOWS})
public class StreamTestCase {
    @TestHTTPResource
    URI uri;
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addClasses(new Class[]{StreamResource.class}));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStreamingDoesNotCloseConnection() throws Exception {
        Vertx v = Vertx.vertx();
        try {
            CompletableFuture<Object> latch = new CompletableFuture<Object>();
            HttpClient client = v.createHttpClient(new HttpClientOptions().setKeepAlive(true).setIdleTimeout(10).setIdleTimeoutUnit(TimeUnit.SECONDS));
            this.sendRequest(latch, client, () -> this.sendRequest(latch, client, () -> latch.complete(null)));
            latch.get();
        }
        finally {
            v.close().toCompletionStage().toCompletableFuture().get();
        }
    }

    private void sendRequest(final CompletableFuture<Object> latch, HttpClient client, final Runnable runnable) {
        final Handler failure = latch::completeExceptionally;
        client.request(HttpMethod.GET, RestAssured.port, "localhost", "/stream/text/stream").onFailure(failure).onSuccess((Handler)new Handler<HttpClientRequest>(){

            public void handle(HttpClientRequest event) {
                event.end();
                event.connect().onFailure(failure).onSuccess(response -> {
                    response.request().connection().closeHandler((Handler)new Handler<Void>(){

                        public void handle(Void event) {
                            latch.completeExceptionally(new Throwable("Connection was closed"));
                        }
                    });
                    response.body().onFailure(failure).onSuccess(buffer -> {
                        try {
                            org.junit.jupiter.api.Assertions.assertEquals((Object)"foobar", (Object)buffer.toString(StandardCharsets.US_ASCII));
                        }
                        catch (Throwable t) {
                            latch.completeExceptionally(t);
                        }
                        runnable.run();
                    });
                });
            }
        });
    }

    @Test
    public void testStreaming() throws Exception {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/stream/text/stream", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"foobar"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/stream/text/stream/publisher", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"foobar"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/stream/text/stream/legacy-publisher", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"foobar"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/stream/text/collect", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"foobar"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/stream/byte-arrays/stream", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"foobar"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/stream/byte-arrays/collect", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"foobar"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/stream/char-arrays/stream", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"foobar"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/stream/char-arrays/stream/publisher", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"foobar"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/stream/char-arrays/collect", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"foobar"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/stream/buffer/stream", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"foobar"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/stream/buffer/collect", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"foobar"), new Matcher[0]);
    }

    @Test
    public void testClientStreaming() throws Exception {
        Client client = ClientBuilder.newBuilder().build();
        WebTarget target = client.target(this.uri.toString() + "stream/text/stream");
        Multi multi = ((MultiInvoker)target.request().rx(MultiInvoker.class)).get(String.class);
        List list = (List)multi.collect().asList().await().atMost(Duration.ofSeconds(5L));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)list.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"foo", list.get(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar", list.get(1));
    }

    @Test
    public void testInfiniteStreamClosedByClientImmediately() throws Exception {
        Client client = ClientBuilder.newBuilder().build();
        WebTarget target = client.target(this.uri.toString() + "stream/infinite/stream");
        Multi multi = ((MultiInvoker)target.request().rx(MultiInvoker.class)).get(String.class);
        Cancellable cancellable = multi.subscribe().with(item -> System.err.println("Received " + item));
        cancellable.cancel();
        Thread.sleep(2000L);
        WebTarget checkTarget = client.target(this.uri.toString() + "stream/infinite/stream-was-cancelled");
        String check = (String)checkTarget.request().get(String.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"OK", (Object)check);
    }

    @Test
    public void testInfiniteStreamClosedByClientAfterRegistration() throws Exception {
        Client client = ClientBuilder.newBuilder().build();
        WebTarget target = client.target(this.uri.toString() + "stream/infinite/stream");
        Multi multi = ((MultiInvoker)target.request().rx(MultiInvoker.class)).get(String.class);
        CountDownLatch latch = new CountDownLatch(2);
        Cancellable cancellable = multi.subscribe().with(item -> {
            System.err.println("Received " + item);
            latch.countDown();
        });
        org.junit.jupiter.api.Assertions.assertTrue((boolean)latch.await(30L, TimeUnit.SECONDS));
        cancellable.cancel();
        Thread.sleep(2000L);
        WebTarget checkTarget = client.target(this.uri.toString() + "stream/infinite/stream-was-cancelled");
        String check = (String)checkTarget.request().get(String.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"OK", (Object)check);
    }

    @Test
    public void testSse() throws InterruptedException {
        Client client = ClientBuilder.newBuilder().build();
        WebTarget target = client.target(this.uri.toString() + "stream/sse");
        try (SseEventSource sse = SseEventSource.target((WebTarget)target).build();){
            CountDownLatch latch = new CountDownLatch(1);
            CopyOnWriteArrayList errors = new CopyOnWriteArrayList();
            CopyOnWriteArrayList results = new CopyOnWriteArrayList();
            sse.register(event -> results.add(event.readData()), error -> errors.add(error), () -> latch.countDown());
            sse.open();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)latch.await(20L, TimeUnit.SECONDS));
            Assertions.assertThat(results).containsExactly((Object[])new String[]{"a", "b", "c"});
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)errors.size());
        }
    }

    @Test
    public void testSseThrows() throws InterruptedException {
        Client client = ClientBuilder.newBuilder().build();
        WebTarget target = client.target(this.uri.toString() + "stream/sse/throws");
        try (SseEventSource sse = SseEventSource.target((WebTarget)target).build();){
            CountDownLatch latch = new CountDownLatch(1);
            CopyOnWriteArrayList errors = new CopyOnWriteArrayList();
            CopyOnWriteArrayList results = new CopyOnWriteArrayList();
            sse.register(event -> results.add(event.readData()), error -> errors.add(error), () -> latch.countDown());
            sse.open();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)latch.await(20L, TimeUnit.SECONDS));
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)results.size());
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)errors.size());
        }
    }

    @Test
    public void testSseForMultiWithOutboundSseEvent() throws InterruptedException {
        Client client = ClientBuilder.newBuilder().build();
        WebTarget target = client.target(this.uri.toString() + "stream/sse/raw");
        try (SseEventSource sse = SseEventSource.target((WebTarget)target).build();){
            CountDownLatch latch = new CountDownLatch(1);
            CopyOnWriteArrayList errors = new CopyOnWriteArrayList();
            CopyOnWriteArrayList results = new CopyOnWriteArrayList();
            CopyOnWriteArrayList ids = new CopyOnWriteArrayList();
            CopyOnWriteArrayList names = new CopyOnWriteArrayList();
            CopyOnWriteArrayList comments = new CopyOnWriteArrayList();
            sse.register(event -> {
                comments.add(event.getComment());
                results.add(event.readData());
                ids.add(event.getId());
                names.add(event.getName());
            }, error -> errors.add(error), () -> latch.countDown());
            sse.open();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)latch.await(20L, TimeUnit.SECONDS));
            Assertions.assertThat(results).containsExactly((Object[])new String[]{"", "uno", "dos", "tres"});
            Assertions.assertThat(ids).containsExactly((Object[])new String[]{null, "one", "two", "three"});
            Assertions.assertThat(names).containsExactly((Object[])new String[]{null, "eins", "zwei", "drei"});
            Assertions.assertThat(comments).containsExactly((Object[])new String[]{"dummy", null, null, null});
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)errors.size());
        }
    }
}

