/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.stress;

import io.quarkus.test.QuarkusUnitTest;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.stream.IntStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.assertj.core.api.Assertions;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.RegisterExtension;

public class DrainTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer(() -> (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{MyEndpoint.class, BytesData.class, Data.class, DataBodyWriter.class})).addAsResource("server-keystore.jks")).overrideConfigKey("quarkus.http.ssl.certificate.key-store-file", "server-keystore.jks").overrideConfigKey("quarkus.http.ssl.certificate.key-store-password", "secret");
    HttpClient client;
    private static final Data DATA = new BytesData(new byte[100000]);

    @Test
    @Timeout(value=30L, threadMode=Timeout.ThreadMode.SEPARATE_THREAD)
    void testAsyncHttp1() {
        this.client = DrainTest.createJavaHttpClient();
        long before = System.currentTimeMillis();
        int sum = IntStream.range(0, 10000).parallel().map(i -> this.get("https://localhost:8444/test/bytesAsync")).sum();
        System.out.println("Request completed in " + (System.currentTimeMillis() - before) + " ms");
        Assertions.assertThat((int)sum).isEqualTo(1000000000);
    }

    @Test
    @Timeout(value=30L, threadMode=Timeout.ThreadMode.SEPARATE_THREAD)
    void testSyncHttp1() {
        this.client = DrainTest.createJavaHttpClient();
        long before = System.currentTimeMillis();
        int sum = IntStream.range(0, 10000).parallel().map(i -> this.get("https://localhost:8444/test/bytesSync")).sum();
        System.out.println("Request completed in " + (System.currentTimeMillis() - before) + " ms");
        Assertions.assertThat((int)sum).isEqualTo(1000000000);
    }

    @Test
    @Timeout(value=30L, threadMode=Timeout.ThreadMode.SEPARATE_THREAD)
    void testAsyncHttp2() {
        this.client = DrainTest.createJavaHttp2Client();
        long before = System.currentTimeMillis();
        int sum = IntStream.range(0, 10000).parallel().map(i -> this.get("https://localhost:8444/test/bytesAsync")).sum();
        System.out.println("Request completed in " + (System.currentTimeMillis() - before) + " ms");
        Assertions.assertThat((int)sum).isEqualTo(1000000000);
    }

    @Test
    @Timeout(value=30L, threadMode=Timeout.ThreadMode.SEPARATE_THREAD)
    void testSyncHttp2() {
        this.client = DrainTest.createJavaHttp2Client();
        long before = System.currentTimeMillis();
        int sum = IntStream.range(0, 10000).parallel().map(i -> this.get("https://localhost:8444/test/bytesSync")).sum();
        System.out.println("Request completed in " + (System.currentTimeMillis() - before) + " ms");
        Assertions.assertThat((int)sum).isEqualTo(1000000000);
    }

    int get(String uri) {
        HttpRequest request = HttpRequest.newBuilder(URI.create(uri)).GET().build();
        HttpResponse<byte[]> response = this.client.sendAsync(request, HttpResponse.BodyHandlers.ofByteArray()).join();
        return response.body().length;
    }

    private static HttpClient createJavaHttpClient() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{AllowAllTrustManager.INSTANCE}, SecureRandom.getInstanceStrong());
            return HttpClient.newBuilder().sslContext(sslContext).build();
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to create HTTP client");
        }
    }

    private static HttpClient createJavaHttp2Client() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{AllowAllTrustManager.INSTANCE}, SecureRandom.getInstanceStrong());
            return HttpClient.newBuilder().sslContext(sslContext).version(HttpClient.Version.HTTP_2).build();
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to create HTTP client");
        }
    }

    private static enum AllowAllTrustManager implements X509TrustManager
    {
        INSTANCE;


        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    @Path(value="/test")
    public static class MyEndpoint {
        @GET
        @Path(value="bytesAsync")
        @Produces(value={"application/json", "application/cbor"})
        public Uni<Data> getBytesAsync() {
            return Uni.createFrom().item((Object)DATA);
        }

        @GET
        @Path(value="bytesSync")
        @Produces(value={"application/json", "application/cbor"})
        public Data getBytesSync() {
            return DATA;
        }
    }

    public record BytesData(byte[] bytes) implements Data
    {
    }

    public static interface Data {
        public byte[] bytes();
    }

    @Provider
    @ApplicationScoped
    @Produces(value={"application/json", "application/cbor"})
    public static class DataBodyWriter
    implements MessageBodyWriter<Data> {
        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return Data.class.isAssignableFrom(type);
        }

        public void writeTo(Data data, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
            entityStream.write(data.bytes());
        }
    }
}

