/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.stress;

import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.resteasy.reactive.server.spi.MethodScannerBuildItem;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.ServerResourceMethod;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class SuspendResumeStressTest {
    private static volatile ExecutorService executorService;
    @RegisterExtension
    static QuarkusUnitTest test;

    @Test
    public void testSuspendResumeStressTest() {
        executorService = Executors.newFixedThreadPool(10);
        try {
            for (int i = 0; i < 100; ++i) {
                ((ValidatableResponse)((Response)RestAssured.when().get("/hello", new Object[0])).then()).body(Matchers.is((Object)"hello"), new Matcher[0]);
            }
        }
        finally {
            executorService.shutdownNow();
            executorService = null;
        }
    }

    static {
        test = new QuarkusUnitTest().addBuildChainCustomizer((Consumer)new Consumer<BuildChainBuilder>(){

            @Override
            public void accept(BuildChainBuilder buildChainBuilder) {
                buildChainBuilder.addBuildStep(new BuildStep(){

                    public void execute(BuildContext context) {
                        context.produce((BuildItem)new MethodScannerBuildItem(new MethodScanner(){

                            public List<HandlerChainCustomizer> scan(MethodInfo method, ClassInfo actualEndpointClass, Map<String, Object> methodContext) {
                                return Collections.singletonList(new Custom());
                            }
                        }));
                    }
                }).produces(MethodScannerBuildItem.class).build();
            }
        }).withApplicationRoot(jar -> jar.addClass(HelloResource.class));
    }

    @Path(value="hello")
    public static class HelloResource {
        @GET
        public String hello() {
            return "hello";
        }
    }

    public static class ResumeHandler
    implements ServerRestHandler {
        public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
            requestContext.suspend();
            executorService.execute(() -> ((ResteasyReactiveRequestContext)requestContext).resume());
        }
    }

    public static class Custom
    implements HandlerChainCustomizer {
        public List<ServerRestHandler> handlers(HandlerChainCustomizer.Phase phase, ResourceClass resourceClass, ServerResourceMethod resourceMethod) {
            ArrayList<ServerRestHandler> handlers = new ArrayList<ServerRestHandler>();
            for (int i = 0; i < 100; ++i) {
                handlers.add(new ResumeHandler());
            }
            return handlers;
        }
    }
}

