/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.transformation;

import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.resteasy.reactive.server.spi.AnnotationsTransformerBuildItem;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.Path;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.transformation.AnnotationsTransformer;
import org.jboss.resteasy.reactive.common.processor.transformation.Transformation;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class AnnotationTransformationTest {
    private static final DotName MY_GET = DotName.createSimple((String)MyGet.class.getName());
    private static final DotName MY_QUERY = DotName.createSimple((String)MyQuery.class.getName());
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().addBuildChainCustomizer((Consumer)new Consumer<BuildChainBuilder>(){

        @Override
        public void accept(BuildChainBuilder buildChainBuilder) {
            buildChainBuilder.addBuildStep(new BuildStep(){

                public void execute(BuildContext context) {
                    context.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

                        public boolean appliesTo(AnnotationTarget.Kind kind) {
                            return kind == AnnotationTarget.Kind.METHOD;
                        }

                        public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
                            AnnotationTarget target = transformationContext.getTarget();
                            if (target.kind() != AnnotationTarget.Kind.METHOD) {
                                return;
                            }
                            MethodInfo methodInfo = target.asMethod();
                            Transformation transform = transformationContext.transform();
                            boolean complete = false;
                            if (methodInfo.hasAnnotation(MY_GET)) {
                                complete = true;
                                transform.add(ResteasyReactiveDotNames.GET, new AnnotationValue[0]);
                            }
                            for (AnnotationInstance annotation : methodInfo.annotations()) {
                                if (annotation.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER || !annotation.name().equals((Object)MY_QUERY)) continue;
                                complete = true;
                                AnnotationValue annotationValue = annotation.value();
                                transform.add(AnnotationInstance.create((DotName)ResteasyReactiveDotNames.QUERY_PARAM, (AnnotationTarget)annotation.target(), Collections.singletonList(annotationValue)));
                            }
                            if (complete) {
                                transform.done();
                            }
                        }
                    }));
                }
            }).produces(AnnotationsTransformerBuildItem.class).build();
        }
    }).withApplicationRoot(jar -> jar.addClasses(new Class[]{TestResource.class, MyGet.class, MyQuery.class}));

    @Test
    public void testNoPath() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/test", (Object[])new Object[0]).then()).statusCode(200)).and()).body(Matchers.equalTo((Object)"no path"), new Matcher[0])).and()).contentType("text/plain");
    }

    @Test
    public void testHello() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/test/hello", (Object[])new Object[0]).then()).statusCode(200)).and()).body(Matchers.equalTo((Object)"hello world"), new Matcher[0])).and()).contentType("text/plain");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/test/hello?nm=foo", (Object[])new Object[0]).then()).statusCode(200)).and()).body(Matchers.equalTo((Object)"hello foo"), new Matcher[0])).and()).contentType("text/plain");
    }

    @Path(value="test")
    public static class TestResource {
        @MyGet
        public String noPath() {
            return "no path";
        }

        @Path(value="hello")
        @MyGet
        public String hello(@MyQuery(value="nm") @DefaultValue(value="world") String name) {
            return "hello " + name;
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface MyGet {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface MyQuery {
        public String value();
    }
}

