/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.websocket;

import io.quarkus.resteasy.reactive.server.test.websocket.WebSocketResource;
import io.quarkus.test.QuarkusUnitTest;
import io.quarkus.test.common.http.TestHTTPResource;
import io.quarkus.vertx.core.runtime.VertxCoreRecorder;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.WebSocket;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class WebSocketTestCase {
    @TestHTTPResource(value="/ws")
    URI uri;
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addClasses(new Class[]{WebSocketResource.class}));

    @Test
    public void testWebSocket() throws Exception {
        try (HttpClient httpClient = ((Vertx)VertxCoreRecorder.getVertx().get()).createHttpClient();){
            final CompletableFuture result = new CompletableFuture();
            httpClient.webSocket(this.uri.getPort(), this.uri.getHost(), this.uri.getPath(), (Handler)new Handler<AsyncResult<WebSocket>>(){

                public void handle(AsyncResult<WebSocket> event) {
                    if (event.failed()) {
                        result.completeExceptionally(event.cause());
                    } else {
                        ((WebSocket)event.result()).exceptionHandler((Handler)new Handler<Throwable>(){

                            public void handle(Throwable event) {
                                result.completeExceptionally(event);
                            }
                        });
                        ((WebSocket)event.result()).textMessageHandler((Handler)new Handler<String>(){

                            public void handle(String event) {
                                result.complete(event);
                            }
                        });
                        ((WebSocket)event.result()).writeTextMessage("Hello World");
                    }
                }
            });
            Assertions.assertEquals((Object)"Hello World", result.get());
        }
    }
}

