/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.links.runtime.hal;

import io.quarkus.hal.HalCollectionWrapper;
import io.quarkus.hal.HalEntityWrapper;
import io.quarkus.hal.HalService;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.resteasy.reactive.server.ServerResponseFilter;
import org.jboss.resteasy.reactive.server.core.CurrentRequestManager;

public class HalServerResponseFilter {
    private static final String COLLECTION_NAME = "items";
    private final HalService service;

    @Inject
    public HalServerResponseFilter(HalService service) {
        this.service = service;
    }

    @ServerResponseFilter
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext, Throwable t) {
        if (t == null) {
            Object entity = responseContext.getEntity();
            if (this.isHttpStatusSuccessful(responseContext.getStatusInfo()) && this.acceptsHalMediaType(requestContext) && this.canEntityBeProcessed(entity)) {
                if (entity instanceof Collection) {
                    responseContext.setEntity((Object)this.service.toHalCollectionWrapper((Collection)entity, COLLECTION_NAME, this.findEntityClass()));
                } else {
                    responseContext.setEntity((Object)this.service.toHalWrapper(entity));
                }
            }
        }
    }

    private boolean canEntityBeProcessed(Object entity) {
        return entity != null && !(entity instanceof String) && !(entity instanceof HalEntityWrapper) && !(entity instanceof HalCollectionWrapper);
    }

    private boolean isHttpStatusSuccessful(Response.StatusType statusInfo) {
        return Response.Status.Family.SUCCESSFUL.equals((Object)statusInfo.getFamily());
    }

    private boolean acceptsHalMediaType(ContainerRequestContext requestContext) {
        List acceptMediaType = requestContext.getAcceptableMediaTypes().stream().map(MediaType::toString).collect(Collectors.toList());
        return acceptMediaType.contains("application/hal+json");
    }

    private Class<?> findEntityClass() {
        Type itemEntityType;
        Type entityType = CurrentRequestManager.get().getTarget().getReturnType();
        if (entityType instanceof ParameterizedType && (itemEntityType = ((ParameterizedType)entityType).getActualTypeArguments()[0]) instanceof Class) {
            return (Class)itemEntityType;
        }
        return null;
    }
}

