/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.resteasy.common.deployment.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.deployment.ResteasyJaxrsConfigBuildItem;
import io.quarkus.resteasy.runtime.NotFoundExceptionMapper;
import io.quarkus.resteasy.runtime.ResteasyFilter;
import io.quarkus.resteasy.runtime.RolesFilterRegistrar;
import io.quarkus.resteasy.server.common.deployment.ResteasyInjectionReadyBuildItem;
import io.quarkus.resteasy.server.common.deployment.ResteasyServerConfigBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.undertow.deployment.FilterBuildItem;
import io.quarkus.undertow.deployment.ServletBuildItem;
import io.quarkus.undertow.deployment.ServletInitParamBuildItem;
import java.util.Map;
import java.util.Optional;
import javax.servlet.DispatcherType;
import javax.ws.rs.core.Application;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;

public class ResteasyProcessor {
    private static final String JAVAX_WS_RS_APPLICATION;
    private static final String JAX_RS_FILTER_NAME;
    private static final String JAX_RS_SERVLET_NAME;

    @BuildStep
    public void jaxrsConfig(Optional<ResteasyServerConfigBuildItem> resteasyServerConfig, BuildProducer<ResteasyJaxrsConfigBuildItem> resteasyJaxrsConfig) {
        if (resteasyServerConfig.isPresent()) {
            resteasyJaxrsConfig.produce((BuildItem)new ResteasyJaxrsConfigBuildItem(resteasyServerConfig.get().getPath()));
        }
    }

    @BuildStep
    public void build(Optional<ResteasyServerConfigBuildItem> resteasyServerConfig, BuildProducer<FeatureBuildItem> feature, BuildProducer<FilterBuildItem> filter, BuildProducer<ServletBuildItem> servlet, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ServletInitParamBuildItem> servletInitParameters, ResteasyInjectionReadyBuildItem resteasyInjectionReady) throws Exception {
        feature.produce((BuildItem)new FeatureBuildItem("resteasy"));
        if (resteasyServerConfig.isPresent()) {
            String path = resteasyServerConfig.get().getPath();
            if (path.equals("/") || path.isEmpty()) {
                filter.produce((BuildItem)FilterBuildItem.builder((String)JAX_RS_FILTER_NAME, (String)ResteasyFilter.class.getName()).setLoadOnStartup(1).addFilterServletNameMapping("default", DispatcherType.REQUEST).setAsyncSupported(true).build());
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{ResteasyFilter.class.getName()}));
            } else {
                String mappingPath = this.getMappingPath(path);
                servlet.produce((BuildItem)ServletBuildItem.builder((String)JAX_RS_SERVLET_NAME, (String)HttpServlet30Dispatcher.class.getName()).setLoadOnStartup(1).addMapping(mappingPath).setAsyncSupported(true).build());
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{HttpServlet30Dispatcher.class.getName()}));
            }
            for (Map.Entry initParameter : resteasyServerConfig.get().getInitParameters().entrySet()) {
                servletInitParameters.produce((BuildItem)new ServletInitParamBuildItem((String)initParameter.getKey(), (String)initParameter.getValue()));
            }
        }
    }

    @BuildStep
    void setupFilter(BuildProducer<ResteasyJaxrsProviderBuildItem> providers) {
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(RolesFilterRegistrar.class.getName()));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupExceptionMapper(BuildProducer<ResteasyJaxrsProviderBuildItem> providers, LaunchModeBuildItem launchMode) {
        if (launchMode.getLaunchMode().equals((Object)LaunchMode.DEVELOPMENT)) {
            providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(NotFoundExceptionMapper.class.getName()));
        }
    }

    private String getMappingPath(String path) {
        String mappingPath = path.endsWith("/") ? path + "*" : path + "/*";
        return mappingPath;
    }

    static {
        JAX_RS_FILTER_NAME = JAVAX_WS_RS_APPLICATION = Application.class.getName();
        JAX_RS_SERVLET_NAME = JAVAX_WS_RS_APPLICATION;
    }
}

