/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.jpa.runtime;

import io.quarkus.hibernate.orm.runtime.JPAConfig;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.UsernamePasswordAuthenticationRequest;
import io.quarkus.security.runtime.QuarkusPrincipal;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.smallrye.mutiny.Uni;
import java.security.Principal;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.jboss.logging.Logger;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.util.ModularCrypt;

public abstract class JpaIdentityProvider
implements IdentityProvider<UsernamePasswordAuthenticationRequest> {
    private static Logger log = Logger.getLogger(JpaIdentityProvider.class);
    @Inject
    JPAConfig jpaConfig;

    public Class<UsernamePasswordAuthenticationRequest> getRequestType() {
        return UsernamePasswordAuthenticationRequest.class;
    }

    public Uni<SecurityIdentity> authenticate(final UsernamePasswordAuthenticationRequest request, AuthenticationRequestContext context) {
        return context.runBlocking((Supplier)new Supplier<SecurityIdentity>(){

            @Override
            public SecurityIdentity get() {
                EntityManager em = JpaIdentityProvider.this.jpaConfig.getEntityManagerFactory(null).createEntityManager();
                ((Session)em).setHibernateFlushMode(FlushMode.MANUAL);
                ((Session)em).setDefaultReadOnly(true);
                try {
                    SecurityIdentity securityIdentity = JpaIdentityProvider.this.authenticate(em, request);
                    return securityIdentity;
                }
                catch (SecurityException e) {
                    log.debug((Object)"Authentication failed", (Throwable)e);
                    throw new AuthenticationFailedException();
                }
                finally {
                    em.close();
                }
            }
        });
    }

    public abstract SecurityIdentity authenticate(EntityManager var1, UsernamePasswordAuthenticationRequest var2);

    protected QuarkusSecurityIdentity.Builder checkPassword(Password storedPassword, UsernamePasswordAuthenticationRequest request) {
        PasswordCredential storedPasswordCredential = new PasswordCredential(storedPassword);
        PasswordGuessEvidence sentPasswordEvidence = new PasswordGuessEvidence(request.getPassword().getPassword());
        if (!storedPasswordCredential.verify((Evidence)sentPasswordEvidence)) {
            throw new AuthenticationFailedException();
        }
        QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder();
        builder.setPrincipal((Principal)new QuarkusPrincipal(request.getUsername()));
        builder.addCredential((Credential)request.getPassword());
        return builder;
    }

    protected void addRoles(QuarkusSecurityIdentity.Builder builder, String roles) {
        if (roles.indexOf(44) != -1) {
            for (String role : roles.split(",")) {
                builder.addRole(role.trim());
            }
        } else {
            builder.addRole(roles.trim());
        }
    }

    protected <T> T getSingleUser(Query query) {
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new AuthenticationFailedException();
        }
        return (T)results.get(0);
    }

    protected Password getClearPassword(String pass) {
        return ClearPassword.createRaw((String)"clear", (char[])pass.toCharArray());
    }

    protected Password getMcfPassword(String pass) {
        try {
            return ModularCrypt.decode((String)pass);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }
}

