/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.webauthn;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.webauthn.WebAuthnAuthenticationMechanism;
import io.quarkus.security.webauthn.WebAuthnAuthenticationRequest;
import io.quarkus.security.webauthn.WebAuthnRunTimeConfig;
import io.quarkus.security.webauthn.WebAuthnSecurity;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.quarkus.vertx.http.runtime.security.PersistentLoginManager;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.webauthn.WebAuthnCredentials;
import io.vertx.ext.auth.webauthn.impl.attestation.AttestationException;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.Origin;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class WebAuthnController {
    private static final Logger log = Logger.getLogger(WebAuthnController.class);
    public static final String USERNAME_COOKIE = "_quarkus_webauthn_username";
    public static final String CHALLENGE_COOKIE = "_quarkus_webauthn_challenge";
    private WebAuthnSecurity security;
    private String origin;
    private String domain;
    private IdentityProviderManager identityProviderManager;
    private WebAuthnAuthenticationMechanism authMech;

    public WebAuthnController(WebAuthnSecurity security, WebAuthnRunTimeConfig config, IdentityProviderManager identityProviderManager, WebAuthnAuthenticationMechanism authMech) {
        this.origin = config.origin.orElse(null);
        if (this.origin != null) {
            Origin o = Origin.parse((String)this.origin);
            this.domain = o.host();
        }
        this.security = security;
        this.identityProviderManager = identityProviderManager;
        this.authMech = authMech;
    }

    private static boolean containsRequiredString(JsonObject json, String key) {
        try {
            if (json == null) {
                return false;
            }
            if (!json.containsKey(key)) {
                return false;
            }
            Object s = json.getValue(key);
            return s instanceof String && !"".equals(s);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private static boolean containsOptionalString(JsonObject json, String key) {
        try {
            if (json == null) {
                return true;
            }
            if (!json.containsKey(key)) {
                return true;
            }
            Object s = json.getValue(key);
            return s instanceof String;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private static boolean containsRequiredObject(JsonObject json, String key) {
        try {
            if (json == null) {
                return false;
            }
            if (!json.containsKey(key)) {
                return false;
            }
            JsonObject s = json.getJsonObject(key);
            return s != null;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public void register(RoutingContext ctx) {
        try {
            JsonObject webauthnRegister = ctx.getBodyAsJson();
            if (webauthnRegister == null || !WebAuthnController.containsRequiredString(webauthnRegister, "name")) {
                ctx.fail(400, (Throwable)new IllegalArgumentException("missing 'name' field from request json"));
            } else {
                ManagedContext requestContext = Arc.container().requestContext();
                requestContext.activate();
                InjectableContext.ContextState contextState = requestContext.getState();
                this.security.getWebAuthn().createCredentialsOptions(webauthnRegister, createCredentialsOptions -> {
                    requestContext.destroy(contextState);
                    if (createCredentialsOptions.failed()) {
                        ctx.fail(createCredentialsOptions.cause());
                        return;
                    }
                    JsonObject credentialsOptions = (JsonObject)createCredentialsOptions.result();
                    this.authMech.getLoginManager().save(credentialsOptions.getString("challenge"), ctx, CHALLENGE_COOKIE, null, ctx.request().isSSL());
                    this.authMech.getLoginManager().save(webauthnRegister.getString("name"), ctx, USERNAME_COOKIE, null, ctx.request().isSSL());
                    WebAuthnController.ok(ctx, credentialsOptions);
                });
            }
        }
        catch (IllegalArgumentException e) {
            ctx.fail(400, (Throwable)e);
        }
        catch (RuntimeException e) {
            ctx.fail((Throwable)e);
        }
    }

    public void login(RoutingContext ctx) {
        try {
            JsonObject webauthnLogin = ctx.getBodyAsJson();
            if (webauthnLogin == null || !WebAuthnController.containsRequiredString(webauthnLogin, "name")) {
                ctx.fail(400, (Throwable)new IllegalArgumentException("Request missing 'name' field"));
                return;
            }
            String username = webauthnLogin.getString("name");
            ManagedContext requestContext = Arc.container().requestContext();
            requestContext.activate();
            InjectableContext.ContextState contextState = requestContext.getState();
            this.security.getWebAuthn().getCredentialsOptions(username, generateServerGetAssertion -> {
                requestContext.destroy(contextState);
                if (generateServerGetAssertion.failed()) {
                    ctx.fail(generateServerGetAssertion.cause());
                    return;
                }
                JsonObject getAssertion = (JsonObject)generateServerGetAssertion.result();
                this.authMech.getLoginManager().save(getAssertion.getString("challenge"), ctx, CHALLENGE_COOKIE, null, ctx.request().isSSL());
                this.authMech.getLoginManager().save(username, ctx, USERNAME_COOKIE, null, ctx.request().isSSL());
                WebAuthnController.ok(ctx, getAssertion);
            });
        }
        catch (IllegalArgumentException e) {
            ctx.fail(400, (Throwable)e);
        }
        catch (RuntimeException e) {
            ctx.fail((Throwable)e);
        }
    }

    public void callback(final RoutingContext ctx) {
        try {
            JsonObject webauthnResp = ctx.getBodyAsJson();
            if (!(webauthnResp != null && WebAuthnController.containsRequiredString(webauthnResp, "id") && WebAuthnController.containsRequiredString(webauthnResp, "rawId") && WebAuthnController.containsRequiredObject(webauthnResp, "response") && WebAuthnController.containsOptionalString(webauthnResp.getJsonObject("response"), "userHandle") && WebAuthnController.containsRequiredString(webauthnResp, "type") && "public-key".equals(webauthnResp.getString("type")))) {
                ctx.fail(400, (Throwable)new IllegalArgumentException("Response missing one or more of id/rawId/response[.userHandle]/type fields, or type is not public-key"));
                return;
            }
            PersistentLoginManager.RestoreResult challenge = this.authMech.getLoginManager().restore(ctx, CHALLENGE_COOKIE);
            PersistentLoginManager.RestoreResult username = this.authMech.getLoginManager().restore(ctx, USERNAME_COOKIE);
            if (challenge == null || challenge.getPrincipal() == null || challenge.getPrincipal().isEmpty() || username == null || username.getPrincipal() == null || username.getPrincipal().isEmpty()) {
                ctx.fail(400, (Throwable)new IllegalArgumentException("Missing challenge or username"));
                return;
            }
            final ManagedContext requestContext = Arc.container().requestContext();
            requestContext.activate();
            final InjectableContext.ContextState contextState = requestContext.getState();
            WebAuthnCredentials credentials = new WebAuthnCredentials().setOrigin(this.origin).setDomain(this.domain).setChallenge(challenge.getPrincipal()).setUsername(username.getPrincipal()).setWebauthn(webauthnResp);
            this.identityProviderManager.authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)new WebAuthnAuthenticationRequest(credentials), (RoutingContext)ctx)).subscribe().with((Consumer)new Consumer<SecurityIdentity>(){

                @Override
                public void accept(SecurityIdentity identity) {
                    requestContext.destroy(contextState);
                    WebAuthnSecurity.removeCookie(ctx, WebAuthnController.CHALLENGE_COOKIE);
                    WebAuthnSecurity.removeCookie(ctx, WebAuthnController.USERNAME_COOKIE);
                    try {
                        WebAuthnController.this.authMech.getLoginManager().save(identity, ctx, null, ctx.request().isSSL());
                        WebAuthnController.ok(ctx);
                    }
                    catch (Throwable t) {
                        log.error((Object)"Unable to complete post authentication", t);
                        ctx.fail(t);
                    }
                }
            }, (Consumer)new Consumer<Throwable>(){

                @Override
                public void accept(Throwable throwable) {
                    requestContext.terminate();
                    if (throwable instanceof AttestationException) {
                        ctx.fail(400, throwable);
                    } else {
                        ctx.fail(throwable);
                    }
                }
            });
        }
        catch (IllegalArgumentException e) {
            ctx.fail(400, (Throwable)e);
        }
        catch (RuntimeException e) {
            ctx.fail((Throwable)e);
        }
    }

    public void logout(RoutingContext ctx) {
        this.authMech.getLoginManager().clear(ctx);
        ctx.redirect("/");
    }

    private static void ok(RoutingContext ctx) {
        ctx.response().setStatusCode(204).end();
    }

    private static void ok(RoutingContext ctx, JsonObject result) {
        ctx.json((Object)result);
    }

    public void javascript(RoutingContext ctx) {
        ctx.response().sendFile("webauthn.js");
    }
}

