/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.webauthn;

import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusPrincipal;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.security.webauthn.WebAuthnAuthenticationMechanism;
import io.quarkus.security.webauthn.WebAuthnAuthenticatorStorage;
import io.quarkus.security.webauthn.WebAuthnLoginResponse;
import io.quarkus.security.webauthn.WebAuthnRegisterResponse;
import io.quarkus.security.webauthn.WebAuthnRunTimeConfig;
import io.quarkus.vertx.http.runtime.security.PersistentLoginManager;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.http.Cookie;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.webauthn.Authenticator;
import io.vertx.ext.auth.webauthn.RelyingParty;
import io.vertx.ext.auth.webauthn.WebAuthn;
import io.vertx.ext.auth.webauthn.WebAuthnCredentials;
import io.vertx.ext.auth.webauthn.WebAuthnOptions;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.Origin;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.security.Principal;

@ApplicationScoped
public class WebAuthnSecurity {
    private WebAuthn webAuthn;
    private String origin;
    private String domain;
    @Inject
    WebAuthnAuthenticationMechanism authMech;

    public WebAuthnSecurity(WebAuthnRunTimeConfig config, Vertx vertx, WebAuthnAuthenticatorStorage database) {
        WebAuthnOptions options = new WebAuthnOptions();
        RelyingParty relyingParty = new RelyingParty();
        if (config.relyingParty.id.isPresent()) {
            relyingParty.setId(config.relyingParty.id.get());
        }
        relyingParty.setName(config.relyingParty.name);
        options.setRelyingParty(relyingParty);
        if (config.attestation.isPresent()) {
            options.setAttestation(config.attestation.get());
        }
        if (config.authenticatorAttachment.isPresent()) {
            options.setAuthenticatorAttachment(config.authenticatorAttachment.get());
        }
        if (config.challengeLength.isPresent()) {
            options.setChallengeLength(config.challengeLength.getAsInt());
        }
        if (config.pubKeyCredParams.isPresent()) {
            options.setPubKeyCredParams(config.pubKeyCredParams.get());
        }
        if (config.requireResidentKey.isPresent()) {
            options.setRequireResidentKey(config.requireResidentKey.get().booleanValue());
        }
        if (config.timeout.isPresent()) {
            options.setTimeoutInMilliseconds(Long.valueOf(config.timeout.get().toMillis()));
        }
        if (config.transports.isPresent()) {
            options.setTransports(config.transports.get());
        }
        if (config.userVerification.isPresent()) {
            options.setUserVerification(config.userVerification.get());
        }
        this.webAuthn = WebAuthn.create((Vertx)vertx, (WebAuthnOptions)options).authenticatorFetcher(database::fetcher).authenticatorUpdater(database::updater);
        this.origin = config.origin.orElse(null);
        if (this.origin != null) {
            Origin o = Origin.parse((String)this.origin);
            this.domain = o.host();
        }
    }

    public Uni<Authenticator> register(WebAuthnRegisterResponse response, RoutingContext ctx) {
        PersistentLoginManager.RestoreResult challenge = this.authMech.getLoginManager().restore(ctx, "_quarkus_webauthn_challenge");
        PersistentLoginManager.RestoreResult username = this.authMech.getLoginManager().restore(ctx, "_quarkus_webauthn_username");
        if (challenge == null || challenge.getPrincipal() == null || challenge.getPrincipal().isEmpty() || username == null || username.getPrincipal() == null || username.getPrincipal().isEmpty()) {
            return Uni.createFrom().failure((Throwable)new RuntimeException("Missing challenge or username"));
        }
        return Uni.createFrom().emitter(emitter -> this.webAuthn.authenticate((Credentials)new WebAuthnCredentials().setOrigin(this.origin).setDomain(this.domain).setChallenge(challenge.getPrincipal()).setUsername(username.getPrincipal()).setWebauthn(response.toJsonObject()), authenticate -> {
            WebAuthnSecurity.removeCookie(ctx, "_quarkus_webauthn_challenge");
            WebAuthnSecurity.removeCookie(ctx, "_quarkus_webauthn_username");
            if (authenticate.succeeded()) {
                emitter.complete((Object)new Authenticator(((User)authenticate.result()).principal()));
            } else {
                emitter.fail(authenticate.cause());
            }
        }));
    }

    public Uni<Authenticator> login(WebAuthnLoginResponse response, RoutingContext ctx) {
        PersistentLoginManager.RestoreResult challenge = this.authMech.getLoginManager().restore(ctx, "_quarkus_webauthn_challenge");
        PersistentLoginManager.RestoreResult username = this.authMech.getLoginManager().restore(ctx, "_quarkus_webauthn_username");
        if (challenge == null || challenge.getPrincipal() == null || challenge.getPrincipal().isEmpty() || username == null || username.getPrincipal() == null || username.getPrincipal().isEmpty()) {
            return Uni.createFrom().failure((Throwable)new RuntimeException("Missing challenge or username"));
        }
        return Uni.createFrom().emitter(emitter -> this.webAuthn.authenticate((Credentials)new WebAuthnCredentials().setOrigin(this.origin).setDomain(this.domain).setChallenge(challenge.getPrincipal()).setUsername(username.getPrincipal()).setWebauthn(response.toJsonObject()), authenticate -> {
            WebAuthnSecurity.removeCookie(ctx, "_quarkus_webauthn_challenge");
            WebAuthnSecurity.removeCookie(ctx, "_quarkus_webauthn_username");
            if (authenticate.succeeded()) {
                emitter.complete((Object)new Authenticator(((User)authenticate.result()).principal()));
            } else {
                emitter.fail(authenticate.cause());
            }
        }));
    }

    static void removeCookie(RoutingContext ctx, String name) {
        Cookie cookie = ctx.request().getCookie(name);
        if (cookie != null) {
            cookie.setPath("/");
        }
        ctx.response().removeCookie(name);
    }

    public WebAuthn getWebAuthn() {
        return this.webAuthn;
    }

    public void rememberUser(String userID, RoutingContext ctx) {
        QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder();
        builder.setPrincipal((Principal)new QuarkusPrincipal(userID));
        this.authMech.getLoginManager().save((SecurityIdentity)builder.build(), ctx, null, ctx.request().isSSL());
    }

    public void logout(RoutingContext ctx) {
        this.authMech.getLoginManager().clear(ctx);
    }
}

