/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.webauthn;

import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.security.webauthn.WebAuthnUserProvider;
import io.smallrye.common.annotation.Blocking;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Future;
import io.vertx.ext.auth.webauthn.Authenticator;
import io.vertx.mutiny.core.Vertx;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

@ApplicationScoped
public class WebAuthnAuthenticatorStorage {
    @Inject
    WebAuthnUserProvider userProvider;
    @Inject
    Vertx vertx;

    public Future<List<Authenticator>> fetcher(Authenticator query) {
        Uni res;
        if (query.getUserName() != null) {
            res = this.runPotentiallyBlocking(() -> this.userProvider.findWebAuthnCredentialsByUserName(query.getUserName()));
        } else if (query.getCredID() != null) {
            res = this.runPotentiallyBlocking(() -> this.userProvider.findWebAuthnCredentialsByCredID(query.getCredID()));
        } else {
            return Future.succeededFuture(Collections.emptyList());
        }
        return Future.fromCompletionStage((CompletionStage)res.subscribeAsCompletionStage());
    }

    private <T> Uni<T> runPotentiallyBlocking(Supplier<Uni<T>> supplier) {
        if (BlockingOperationControl.isBlockingAllowed() || !this.isBlocking(this.userProvider.getClass())) {
            return supplier.get();
        }
        return this.vertx.executeBlocking(Uni.createFrom().deferred(supplier));
    }

    private boolean isBlocking(Class<?> klass) {
        do {
            if (klass.isAnnotationPresent(Blocking.class)) {
                return true;
            }
            if (!klass.isAnnotationPresent(NonBlocking.class)) continue;
            return false;
        } while ((klass = klass.getSuperclass()) != null);
        return false;
    }

    public Future<Void> updater(Authenticator authenticator) {
        return Future.fromCompletionStage((CompletionStage)this.runPotentiallyBlocking(() -> this.userProvider.updateOrStoreWebAuthnCredentials(authenticator)).subscribeAsCompletionStage());
    }
}

