/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.client.runtime;

import io.quarkus.smallrye.graphql.client.runtime.GraphQLClientsConfig;
import io.quarkus.tls.CertificateUpdatedEvent;
import io.quarkus.tls.TlsConfiguration;
import io.smallrye.graphql.client.impl.GraphQLClientConfiguration;
import io.smallrye.graphql.client.impl.GraphQLClientsConfiguration;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.jboss.logging.Logger;

@Singleton
public class GraphQLClientCertificateUpdateEventListener {
    private static final Logger LOG = Logger.getLogger(GraphQLClientCertificateUpdateEventListener.class);
    @Inject
    GraphQLClientsConfig graphQLClientsConfig;

    public void onCertificateUpdate(@Observes CertificateUpdatedEvent event) {
        String updatedTlsConfigurationName = event.name();
        TlsConfiguration updatedTlsConfiguration = event.tlsConfiguration();
        this.graphQLClientsConfig.clients().forEach((configKey, clientConfig) -> {
            GraphQLClientConfiguration graphQLClientConfiguration = GraphQLClientsConfiguration.getInstance().getClient(configKey);
            clientConfig.tlsConfigurationName().ifPresentOrElse(tlsConfigurationName -> {
                if (tlsConfigurationName.equals(updatedTlsConfigurationName)) {
                    this.updateConfiguration(updatedTlsConfigurationName, updatedTlsConfiguration, graphQLClientConfiguration, (String)configKey);
                }
            }, () -> {
                if ("<default>".equals(updatedTlsConfigurationName)) {
                    this.updateConfiguration("default", updatedTlsConfiguration, graphQLClientConfiguration, (String)configKey);
                }
            });
        });
    }

    private void updateConfiguration(String tlsBucketName, TlsConfiguration updatedTlsConfiguration, GraphQLClientConfiguration graphQLClientConfiguration, String configKey) {
        LOG.infof("Certificate reloaded for the client '%s' using the TLS configuration (bucket) name '%s'", (Object)configKey, (Object)tlsBucketName);
        graphQLClientConfiguration.setTlsKeyStoreOptions((Object)updatedTlsConfiguration.getKeyStoreOptions());
        graphQLClientConfiguration.setTlsTrustStoreOptions((Object)updatedTlsConfiguration.getTrustStoreOptions());
        graphQLClientConfiguration.setSslOptions((Object)updatedTlsConfiguration.getSSLOptions());
    }
}

