/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime;

import graphql.ErrorType;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.GraphqlErrorBuilder;
import graphql.execution.AbortExecutionException;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLAbstractHandler;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.smallrye.graphql.execution.ExecutionResponse;
import io.smallrye.graphql.execution.ExecutionResponseWriter;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.ParsedHeaderValues;
import io.vertx.ext.web.RoutingContext;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParsingException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

public class SmallRyeGraphQLExecutionHandler
extends SmallRyeGraphQLAbstractHandler {
    private final boolean allowGet;
    private final boolean allowPostWithQueryParameters;
    private static final String QUERY = "query";
    private static final String OPERATION_NAME = "operationName";
    private static final String VARIABLES = "variables";
    private static final String EXTENSIONS = "extensions";
    private static final String APPLICATION_GRAPHQL = "application/graphql";
    private static final String OK = "OK";
    private static final String DEFAULT_RESPONSE_CONTENT_TYPE = "application/graphql-response+json; charset=" + StandardCharsets.UTF_8.name();
    private static final String DEFAULT_REQUEST_CONTENT_TYPE = "application/json; charset=" + StandardCharsets.UTF_8.name();
    private static final String MISSING_OPERATION = "Missing operation body";
    private static final Logger log = Logger.getLogger(SmallRyeGraphQLExecutionHandler.class);
    private static final String CHARSET_TOKEN = "charset=";
    private static final String UTF_8_LOW = "utf-8";
    private static final String UTF_8_HIGH = "UTF-8";
    private static final Pattern PATTERN_NEWLINE_OR_TAB = Pattern.compile("\\n|\\t|\\r");

    public SmallRyeGraphQLExecutionHandler(boolean allowGet, boolean allowPostWithQueryParameters, boolean runBlocking, CurrentIdentityAssociation currentIdentityAssociation, CurrentVertxRequest currentVertxRequest) {
        super(currentIdentityAssociation, currentVertxRequest, runBlocking);
        this.allowGet = allowGet;
        this.allowPostWithQueryParameters = allowPostWithQueryParameters;
    }

    @Override
    protected void doHandle(RoutingContext ctx) {
        HttpServerRequest request = ctx.request();
        HttpServerResponse response = ctx.response();
        String accept = this.getRequestAccept(ctx);
        String requestedCharset = SmallRyeGraphQLExecutionHandler.getCharset(accept);
        boolean isValid = this.isValidAcceptRequest(accept);
        if (!isValid) {
            this.handleInvalidAcceptRequest(response);
        } else {
            response.headers().set(HttpHeaders.CONTENT_TYPE, (CharSequence)accept);
            switch (request.method().name()) {
                case "OPTIONS": {
                    this.handleOptions(response);
                    break;
                }
                case "POST": {
                    this.handlePost(response, ctx, requestedCharset);
                    break;
                }
                case "GET": {
                    this.handleGet(response, ctx, requestedCharset);
                    break;
                }
                default: {
                    ctx.next();
                }
            }
        }
    }

    private void handleOptions(HttpServerResponse response) {
        response.headers().set(HttpHeaders.ALLOW, (CharSequence)this.getAllowedMethods());
        response.setStatusCode(200).setStatusMessage(OK).end();
    }

    private void handlePost(HttpServerResponse response, RoutingContext ctx, String requestedCharset) {
        try {
            JsonObject jsonObjectFromBody = this.getJsonObjectFromBody(ctx);
            if (this.hasQueryParameters(ctx) && this.allowPostWithQueryParameters) {
                JsonObject jsonObjectFromQueryParameters = this.getJsonObjectFromQueryParameters(ctx);
                JsonObject mergedJsonObject = jsonObjectFromBody != null ? Json.createMergePatch((JsonValue)jsonObjectFromQueryParameters).apply((JsonValue)jsonObjectFromBody).asJsonObject() : jsonObjectFromQueryParameters;
                if (!mergedJsonObject.containsKey((Object)QUERY)) {
                    response.setStatusCode(400).end(MISSING_OPERATION);
                    return;
                }
                this.doRequest(mergedJsonObject, response, ctx, requestedCharset);
            } else {
                if (jsonObjectFromBody == null) {
                    response.setStatusCode(400).end(MISSING_OPERATION);
                    return;
                }
                this.doRequest(jsonObjectFromBody, response, ctx, requestedCharset);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (JsonParsingException ex) {
            this.sendError("Unparseable request", response, ctx, requestedCharset);
        }
    }

    private void handleGet(HttpServerResponse response, RoutingContext ctx, String requestedCharset) {
        if (this.allowGet) {
            try {
                JsonObject input = this.getJsonObjectFromQueryParameters(ctx);
                if (input.containsKey((Object)QUERY)) {
                    this.doRequest(input, response, ctx, requestedCharset);
                }
                response.setStatusCode(400).end(MISSING_OPERATION);
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException(uee);
            }
        } else {
            response.setStatusCode(405).end();
        }
    }

    private void handleInvalidAcceptRequest(HttpServerResponse response) {
        response.setStatusCode(406).end();
    }

    private JsonObject getJsonObjectFromQueryParameters(RoutingContext ctx) throws UnsupportedEncodingException {
        String extensions;
        String variables;
        String operationName;
        JsonObjectBuilder input = Json.createObjectBuilder();
        String query = SmallRyeGraphQLExecutionHandler.stripNewlinesAndTabs(this.readQueryParameter(ctx, QUERY));
        if (query != null && !query.isEmpty()) {
            input.add(QUERY, URLDecoder.decode(query, StandardCharsets.UTF_8.name()));
        }
        if ((operationName = this.readQueryParameter(ctx, OPERATION_NAME)) != null && !operationName.isEmpty()) {
            input.add(OPERATION_NAME, URLDecoder.decode(query, StandardCharsets.UTF_8.name()));
        }
        if ((variables = SmallRyeGraphQLExecutionHandler.stripNewlinesAndTabs(this.readQueryParameter(ctx, VARIABLES))) != null && !variables.isEmpty()) {
            JsonObject jsonObject = SmallRyeGraphQLExecutionHandler.toJsonObject(URLDecoder.decode(variables, StandardCharsets.UTF_8.name()));
            input.add(VARIABLES, (JsonValue)jsonObject);
        }
        if ((extensions = SmallRyeGraphQLExecutionHandler.stripNewlinesAndTabs(this.readQueryParameter(ctx, EXTENSIONS))) != null && !extensions.isEmpty()) {
            JsonObject jsonObject = SmallRyeGraphQLExecutionHandler.toJsonObject(URLDecoder.decode(extensions, StandardCharsets.UTF_8.name()));
            input.add(EXTENSIONS, (JsonValue)jsonObject);
        }
        return input.build();
    }

    private JsonObject getJsonObjectFromBody(RoutingContext ctx) throws IOException {
        String contentType = this.getRequestContentType(ctx);
        String body = SmallRyeGraphQLExecutionHandler.stripNewlinesAndTabs(this.readBody(ctx));
        if (contentType != null && contentType.startsWith(APPLICATION_GRAPHQL)) {
            JsonObjectBuilder input = Json.createObjectBuilder();
            input.add(QUERY, body);
            return input.build();
        }
        if (body == null || body.isEmpty()) {
            return null;
        }
        try (StringReader bodyReader = new StringReader(body);){
            JsonObject jsonObject;
            block13: {
                JsonReader jsonReader = jsonReaderFactory.createReader((Reader)bodyReader);
                try {
                    jsonObject = jsonReader.readObject();
                    if (jsonReader == null) break block13;
                }
                catch (Throwable throwable) {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonReader.close();
            }
            return jsonObject;
        }
    }

    private String readBody(RoutingContext ctx) {
        if (ctx.body() != null) {
            return ctx.body().asString();
        }
        return null;
    }

    private String getRequestContentType(RoutingContext ctx) {
        String contentType = ctx.request().getHeader("Content-Type");
        if (contentType != null && !contentType.isEmpty() && !contentType.startsWith("*/*")) {
            return contentType;
        }
        return DEFAULT_REQUEST_CONTENT_TYPE;
    }

    private String getRequestAccept(RoutingContext ctx) {
        ParsedHeaderValues parsedHeaders = ctx.parsedHeaders();
        if (parsedHeaders != null && parsedHeaders.accept() != null && !parsedHeaders.accept().isEmpty()) {
            List acceptList = parsedHeaders.accept();
            for (MIMEHeader a : acceptList) {
                if (this.isValidAcceptRequest(a.rawValue())) {
                    return a.rawValue();
                }
                if (!a.rawValue().startsWith("*/*")) continue;
                return DEFAULT_RESPONSE_CONTENT_TYPE;
            }
            String accept = ctx.request().getHeader("Accept");
            if (accept != null && !accept.isEmpty()) {
                return accept;
            }
        }
        return DEFAULT_RESPONSE_CONTENT_TYPE;
    }

    private static int indexOfSemicolonOrWhitespace(String s, int start) {
        for (int i = start; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != ';' && !Character.isWhitespace(c)) continue;
            return i;
        }
        return -1;
    }

    private static String parseCharset(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        int charsetIndex = mimeType.indexOf(CHARSET_TOKEN);
        if (charsetIndex == -1) {
            return null;
        }
        int charsetValueStart = charsetIndex + CHARSET_TOKEN.length();
        int firstSemicolonWhitespace = SmallRyeGraphQLExecutionHandler.indexOfSemicolonOrWhitespace(mimeType, charsetValueStart);
        int charsetValueEnd = firstSemicolonWhitespace == -1 ? mimeType.length() : firstSemicolonWhitespace;
        int charsetLen = charsetValueEnd - charsetValueStart;
        if (charsetLen == 0) {
            return null;
        }
        return SmallRyeGraphQLExecutionHandler.charsetOf(mimeType, charsetValueStart, charsetLen);
    }

    private static String charsetOf(String mimeType, int charsetValueStart, int charsetLen) {
        if (charsetLen == UTF_8_LOW.length()) {
            if (mimeType.regionMatches(charsetValueStart, UTF_8_LOW, 0, UTF_8_LOW.length())) {
                return UTF_8_LOW;
            }
            if (mimeType.regionMatches(charsetValueStart, UTF_8_HIGH, 0, UTF_8_LOW.length())) {
                return UTF_8_HIGH;
            }
        }
        return mimeType.substring(charsetValueStart, charsetValueStart + charsetLen);
    }

    private static String getCharset(String mimeType) {
        String parsedCharset = SmallRyeGraphQLExecutionHandler.parseCharset(mimeType);
        if (parsedCharset != null) {
            return parsedCharset;
        }
        return StandardCharsets.UTF_8.name();
    }

    private boolean isValidAcceptRequest(String mimeType) {
        return mimeType.startsWith("application/json") || mimeType.startsWith("application/graphql-response+json") || mimeType.startsWith("application/graphql+json");
    }

    private String readQueryParameter(RoutingContext ctx, String parameterName) {
        List all = ctx.queryParam(parameterName);
        if (all != null && !all.isEmpty()) {
            return (String)all.get(0);
        }
        return null;
    }

    private static String stripNewlinesAndTabs(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return PATTERN_NEWLINE_OR_TAB.matcher(input).replaceAll(" ");
    }

    private boolean hasQueryParameters(RoutingContext ctx) {
        return this.hasQueryParameter(ctx, QUERY) || this.hasQueryParameter(ctx, OPERATION_NAME) || this.hasQueryParameter(ctx, VARIABLES) || this.hasQueryParameter(ctx, EXTENSIONS);
    }

    private boolean hasQueryParameter(RoutingContext ctx, String parameterName) {
        List all = ctx.queryParam(parameterName);
        return all != null && !all.isEmpty();
    }

    private String getAllowedMethods() {
        if (this.allowGet) {
            return "GET, POST, OPTIONS";
        }
        return "POST, OPTIONS";
    }

    private void sendError(String errorMessage, HttpServerResponse response, RoutingContext ctx, String requestedCharset) {
        VertxExecutionResponseWriter writer = new VertxExecutionResponseWriter(response, ctx, requestedCharset);
        GraphQLError error = GraphqlErrorBuilder.newError().message(errorMessage, new Object[0]).build();
        ExecutionResult executionResult = ExecutionResultImpl.newExecutionResult().addError(error).build();
        ExecutionResponse executionResponse = new ExecutionResponse(executionResult);
        writer.write(executionResponse);
    }

    private void doRequest(JsonObject jsonInput, HttpServerResponse response, RoutingContext ctx, String requestedCharset) {
        VertxExecutionResponseWriter writer = new VertxExecutionResponseWriter(response, ctx, requestedCharset);
        this.getExecutionService().executeAsync(jsonInput, this.getMetaData(ctx), (ExecutionResponseWriter)writer);
    }

    private static JsonObject toJsonObject(String jsonString) {
        if (jsonString == null || jsonString.isEmpty()) {
            return null;
        }
        try (JsonReader jsonReader = jsonReaderFactory.createReader((Reader)new StringReader(jsonString));){
            JsonObject jsonObject = jsonReader.readObject();
            return jsonObject;
        }
    }

    class VertxExecutionResponseWriter
    implements ExecutionResponseWriter {
        HttpServerResponse response;
        String requestedCharset;
        RoutingContext ctx;

        VertxExecutionResponseWriter(HttpServerResponse response, RoutingContext ctx, String requestedCharset) {
            this.response = response;
            this.ctx = ctx;
            this.requestedCharset = requestedCharset;
        }

        public void write(ExecutionResponse er) {
            block4: {
                if (this.shouldFail(er)) {
                    er.getExecutionResult().getErrors().stream().filter(e -> e.getErrorType().equals(ErrorType.ExecutionAborted)).forEach(e -> log.error((Object)"Execution aborted", (Throwable)((AbortExecutionException)e)));
                    this.response.setStatusCode(500).end();
                } else {
                    try {
                        this.response.setStatusCode(200).setStatusMessage(SmallRyeGraphQLExecutionHandler.OK).end(Buffer.buffer((String)er.getExecutionResultAsString(), (String)this.requestedCharset));
                    }
                    catch (IllegalStateException ise) {
                        if (!log.isDebugEnabled()) break block4;
                        log.debug((Object)"Cannot write response", (Throwable)ise);
                    }
                }
            }
        }

        public void fail(Throwable t) {
            this.ctx.fail(t);
        }

        private boolean shouldFail(ExecutionResponse er) {
            ExecutionResult executionResult = er.getExecutionResult();
            if (executionResult.isDataPresent() && executionResult.getErrors().size() > 0) {
                for (GraphQLError error : executionResult.getErrors()) {
                    if (!error.getErrorType().equals(ErrorType.ExecutionAborted)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

