/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.di.deployment;

import io.quarkus.arc.deployment.AdditionalStereotypeBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.spring.di.deployment.SpringBeanNameToDotNameBuildItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.DefinitionException;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;

public class SpringDIProcessor {
    private static final DotName SPRING_SCOPE_ANNOTATION = DotName.createSimple((String)"org.springframework.context.annotation.Scope");
    static final DotName SPRING_COMPONENT = DotName.createSimple((String)"org.springframework.stereotype.Component");
    static final DotName SPRING_SERVICE = DotName.createSimple((String)"org.springframework.stereotype.Service");
    static final DotName SPRING_REPOSITORY = DotName.createSimple((String)"org.springframework.stereotype.Repository");
    private static final Set<DotName> SPRING_STEREOTYPE_ANNOTATIONS = Arrays.stream(new DotName[]{SPRING_COMPONENT, SPRING_SERVICE, SPRING_REPOSITORY}).collect(Collectors.toSet());
    private static final DotName CONFIGURATION_ANNOTATION = DotName.createSimple((String)"org.springframework.context.annotation.Configuration");
    private static final DotName BEAN_ANNOTATION = DotName.createSimple((String)"org.springframework.context.annotation.Bean");
    private static final DotName AUTOWIRED_ANNOTATION = DotName.createSimple((String)"org.springframework.beans.factory.annotation.Autowired");
    private static final DotName SPRING_QUALIFIER_ANNOTATION = DotName.createSimple((String)"org.springframework.beans.factory.annotation.Qualifier");
    private static final DotName SPRING_VALUE_ANNOTATION = DotName.createSimple((String)"org.springframework.beans.factory.annotation.Value");
    private static final DotName CDI_SINGLETON_ANNOTATION = BuiltinScope.SINGLETON.getInfo().getDotName();
    private static final DotName CDI_DEPENDENT_ANNOTATION = BuiltinScope.DEPENDENT.getInfo().getDotName();
    private static final DotName CDI_REQUEST_SCOPED_ANNOTATION = BuiltinScope.REQUEST.getInfo().getDotName();
    private static final DotName CDI_SESSION_SCOPED_ANNOTATION = DotName.createSimple((String)"javax.enterprise.context.SessionScoped");
    private static final DotName CDI_APP_SCOPED_ANNOTATION = BuiltinScope.APPLICATION.getInfo().getDotName();
    private static final DotName CDI_NAMED_ANNOTATION = DotNames.NAMED;
    private static final DotName CDI_INJECT_ANNOTATION = DotNames.INJECT;
    private static final DotName CDI_PRODUCES_ANNOTATION = DotNames.PRODUCES;
    private static final DotName MP_CONFIG_PROPERTY_ANNOTATION = DotName.createSimple((String)ConfigProperty.class.getName());
    static final int ANNOTATION = 8192;

    static boolean isAnnotation(int mod) {
        return (mod & 0x2000) != 0;
    }

    @BuildStep
    FeatureBuildItem registerFeature() {
        return new FeatureBuildItem(Feature.SPRING_DI);
    }

    @BuildStep
    SpringBeanNameToDotNameBuildItem createBeanNamesMap(BeanArchiveIndexBuildItem beanArchiveIndexBuildItem) {
        HashMap<String, DotName> result = new HashMap<String, DotName>();
        IndexView index = beanArchiveIndexBuildItem.getIndex();
        ArrayList stereotypeInstances = new ArrayList();
        stereotypeInstances.addAll(index.getAnnotations(SPRING_COMPONENT));
        stereotypeInstances.addAll(index.getAnnotations(SPRING_REPOSITORY));
        stereotypeInstances.addAll(index.getAnnotations(SPRING_SERVICE));
        for (AnnotationInstance stereotypeInstance : stereotypeInstances) {
            if (stereotypeInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            result.put(this.getBeanNameFromStereotypeInstance(stereotypeInstance), stereotypeInstance.target().asClass().name());
        }
        for (AnnotationInstance beanInstance : index.getAnnotations(BEAN_ANNOTATION)) {
            if (beanInstance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            result.put(this.getBeanNameFromBeanInstance(beanInstance), beanInstance.target().asMethod().returnType().name());
        }
        return new SpringBeanNameToDotNameBuildItem(result);
    }

    @BuildStep
    AnnotationsTransformerBuildItem beanTransformer(BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, BuildProducer<AdditionalStereotypeBuildItem> additionalStereotypeBuildItemBuildProducer) {
        IndexView index = beanArchiveIndexBuildItem.getIndex();
        Map<DotName, Set<DotName>> stereotypeScopes = this.getStereotypeScopes(index);
        HashMap instances = new HashMap();
        for (DotName name : stereotypeScopes.keySet()) {
            instances.put(name, index.getAnnotations(name).stream().filter(it -> it.target().kind() == AnnotationTarget.Kind.CLASS && SpringDIProcessor.isAnnotation(it.target().asClass().flags())).collect(Collectors.toSet()));
        }
        additionalStereotypeBuildItemBuildProducer.produce((BuildItem)new AdditionalStereotypeBuildItem(instances));
        return new AnnotationsTransformerBuildItem(context -> {
            Collection annotations = context.getAnnotations();
            if (annotations.isEmpty()) {
                return;
            }
            AnnotationTarget target = context.getTarget();
            Set<AnnotationInstance> annotationsToAdd = this.getAnnotationsToAdd(target, stereotypeScopes, Arrays.stream(BuiltinScope.values()).map(BuiltinScope::getName).collect(Collectors.toList()));
            if (!annotationsToAdd.isEmpty()) {
                Transformation transform = context.transform();
                for (AnnotationInstance annotationInstance : annotationsToAdd) {
                    transform.add(annotationInstance);
                }
                transform.done();
            }
        });
    }

    Map<DotName, Set<DotName>> getStereotypeScopes(IndexView index) {
        HashMap<DotName, Set<DotName>> scopes = new HashMap<DotName, Set<DotName>>();
        scopes.put(SPRING_COMPONENT, Collections.emptySet());
        scopes.put(SPRING_REPOSITORY, Collections.emptySet());
        scopes.put(SPRING_SERVICE, Collections.emptySet());
        List<ClassInfo> allAnnotations = this.getOrderedAnnotations(index);
        HashSet<DotName> stereotypeClasses = new HashSet<DotName>(SPRING_STEREOTYPE_ANNOTATIONS);
        for (ClassInfo clazz : allAnnotations) {
            Set clazzAnnotations = clazz.annotations().keySet();
            HashSet<DotName> clazzStereotypes = new HashSet<DotName>();
            HashSet<DotName> clazzScopes = new HashSet<DotName>();
            for (DotName dotName : stereotypeClasses) {
                if (!clazzAnnotations.contains(dotName)) continue;
                clazzStereotypes.add(dotName);
            }
            if (clazzStereotypes.isEmpty()) continue;
            DotName name = clazz.name();
            stereotypeClasses.add(name);
            for (DotName stereotype : clazzStereotypes) {
                Set vals = (Set)scopes.get(stereotype);
                if (vals == null) continue;
                clazzScopes.addAll(vals);
            }
            DotName dotName = this.getScope((AnnotationTarget)clazz);
            if (dotName != null) {
                clazzScopes.add(dotName);
            }
            scopes.put(name, clazzScopes);
        }
        return scopes;
    }

    private DotName getScope(AnnotationTarget target) {
        AnnotationValue value = null;
        if (target.kind() == AnnotationTarget.Kind.CLASS) {
            if (target.asClass().classAnnotation(SPRING_SCOPE_ANNOTATION) != null) {
                value = target.asClass().classAnnotation(SPRING_SCOPE_ANNOTATION).value();
            }
        } else if (target.kind() == AnnotationTarget.Kind.METHOD && target.asMethod().hasAnnotation(SPRING_SCOPE_ANNOTATION)) {
            value = target.asMethod().annotation(SPRING_SCOPE_ANNOTATION).value();
        }
        if (value != null) {
            switch (value.asString()) {
                case "singleton": {
                    return CDI_SINGLETON_ANNOTATION;
                }
                case "request": {
                    return CDI_REQUEST_SCOPED_ANNOTATION;
                }
                case "global session": 
                case "application": {
                    return CDI_APP_SCOPED_ANNOTATION;
                }
                case "session": {
                    return CDI_SESSION_SCOPED_ANNOTATION;
                }
                case "websocket": 
                case "prototype": {
                    return CDI_DEPENDENT_ANNOTATION;
                }
            }
        }
        return null;
    }

    private List<ClassInfo> getOrderedAnnotations(IndexView index) {
        HashMap<DotName, Set<DotName>> deps = new HashMap<DotName, Set<DotName>>();
        for (ClassInfo clazz : index.getKnownClasses()) {
            if (!SpringDIProcessor.isAnnotation(clazz.flags())) continue;
            deps.put(clazz.name(), clazz.annotations().keySet());
        }
        ArrayList<ClassInfo> ret = new ArrayList<ClassInfo>();
        HashSet<DotName> visited = new HashSet<DotName>();
        for (DotName clazz : deps.keySet()) {
            this.visitAnnotation(clazz, index, deps, visited, ret);
        }
        return ret;
    }

    private void visitAnnotation(DotName clazz, IndexView index, Map<DotName, Set<DotName>> deps, Set<DotName> visited, List<ClassInfo> ret) {
        ClassInfo classInfo;
        if (visited.contains(clazz)) {
            return;
        }
        visited.add(clazz);
        Set<DotName> annotations = deps.get(clazz);
        if (annotations != null) {
            for (DotName annotation : annotations) {
                this.visitAnnotation(annotation, index, deps, visited, ret);
            }
        }
        if ((classInfo = index.getClassByName(clazz)) != null) {
            ret.add(classInfo);
        }
    }

    Set<AnnotationInstance> getAnnotationsToAdd(AnnotationTarget target, Map<DotName, Set<DotName>> stereotypeScopes, List<DotName> allArcScopes) {
        HashSet<AnnotationInstance> annotationsToAdd;
        block22: {
            block23: {
                FieldInfo fieldInfo;
                block24: {
                    AnnotationInstance annotation;
                    AnnotationValue annotationValue;
                    block21: {
                        List<DotName> arcScopes = allArcScopes != null ? allArcScopes : Arrays.stream(BuiltinScope.values()).map(i -> i.getName()).collect(Collectors.toList());
                        Set<DotName> stereotypes = stereotypeScopes.keySet();
                        annotationsToAdd = new HashSet<AnnotationInstance>();
                        if (target.kind() != AnnotationTarget.Kind.CLASS) break block21;
                        ClassInfo classInfo = target.asClass();
                        HashSet<DotName> scopes = new HashSet<DotName>();
                        HashSet<DotName> scopeStereotypes = new HashSet<DotName>();
                        HashSet<String> names = new HashSet<String>();
                        Set clazzAnnotations = classInfo.annotations().keySet();
                        for (AnnotationInstance instance : classInfo.classAnnotations()) {
                            if (!arcScopes.contains(instance.name())) continue;
                            return annotationsToAdd;
                        }
                        for (DotName clazzAnnotation : clazzAnnotations) {
                            if (!stereotypes.contains(clazzAnnotation)) continue;
                            scopeStereotypes.add(clazzAnnotation);
                            Set<DotName> scopeNames = stereotypeScopes.get(clazzAnnotation);
                            if (scopeNames != null) {
                                scopes.addAll(scopeNames);
                            }
                            if (!SPRING_STEREOTYPE_ANNOTATIONS.contains(clazzAnnotation) || SpringDIProcessor.isAnnotation(classInfo.flags())) continue;
                            names.add(this.getBeanNameFromStereotypeInstance(classInfo.classAnnotation(clazzAnnotation)));
                        }
                        DotName declaredScope = this.getScope((AnnotationTarget)classInfo);
                        if (declaredScope == null && classInfo.classAnnotation(CDI_NAMED_ANNOTATION) != null) {
                            declaredScope = CDI_SINGLETON_ANNOTATION;
                        }
                        boolean isAnnotation = SpringDIProcessor.isAnnotation(classInfo.flags());
                        if (declaredScope != null) {
                            annotationsToAdd.add(AnnotationInstance.create((DotName)declaredScope, (AnnotationTarget)target, Collections.emptyList()));
                        } else if (!(isAnnotation && scopes.isEmpty() || classInfo.annotations().containsKey(CONFIGURATION_ANNOTATION))) {
                            boolean shouldAdd = false;
                            for (DotName clazzAnnotation : clazzAnnotations) {
                                if (!stereotypes.contains(clazzAnnotation) && !scopeStereotypes.contains(clazzAnnotation)) continue;
                                shouldAdd = true;
                                break;
                            }
                            if (shouldAdd) {
                                DotName scope = this.validateScope(classInfo, scopes, scopeStereotypes);
                                annotationsToAdd.add(AnnotationInstance.create((DotName)scope, (AnnotationTarget)target, Collections.emptyList()));
                            }
                        }
                        String name = this.validateName(classInfo, names);
                        if (name != null) {
                            annotationsToAdd.add(AnnotationInstance.create((DotName)CDI_NAMED_ANNOTATION, (AnnotationTarget)target, Collections.singletonList(AnnotationValue.createStringValue((String)"value", (String)name))));
                        }
                        if (classInfo.annotations().containsKey(CONFIGURATION_ANNOTATION)) {
                            annotationsToAdd.add(AnnotationInstance.create((DotName)CDI_APP_SCOPED_ANNOTATION, (AnnotationTarget)target, Collections.emptyList()));
                        }
                        if (isAnnotation && !annotationsToAdd.isEmpty()) {
                            annotationsToAdd.add(AnnotationInstance.create((DotName)DotNames.STEREOTYPE, (AnnotationTarget)target, Collections.emptyList()));
                        }
                        break block22;
                    }
                    if (target.kind() != AnnotationTarget.Kind.FIELD) break block23;
                    fieldInfo = target.asField();
                    if (!fieldInfo.hasAnnotation(AUTOWIRED_ANNOTATION)) break block24;
                    annotationsToAdd.add(AnnotationInstance.create((DotName)CDI_INJECT_ANNOTATION, (AnnotationTarget)target, Collections.emptyList()));
                    if (fieldInfo.hasAnnotation(SPRING_QUALIFIER_ANNOTATION) && (annotationValue = (annotation = fieldInfo.annotation(SPRING_QUALIFIER_ANNOTATION)).value()) != null) {
                        String value = annotationValue.asString();
                        annotationsToAdd.add(AnnotationInstance.create((DotName)CDI_NAMED_ANNOTATION, (AnnotationTarget)target, Collections.singletonList(AnnotationValue.createStringValue((String)"value", (String)value))));
                    }
                    break block22;
                }
                if (!fieldInfo.hasAnnotation(SPRING_VALUE_ANNOTATION)) break block22;
                AnnotationInstance annotation = fieldInfo.annotation(SPRING_VALUE_ANNOTATION);
                this.addSpringValueAnnotations(target, annotation, true, annotationsToAdd);
                break block22;
            }
            if (target.kind() == AnnotationTarget.Kind.METHOD) {
                MethodInfo methodInfo = target.asMethod();
                if (methodInfo.hasAnnotation(BEAN_ANNOTATION) && methodInfo.declaringClass().classAnnotation(CONFIGURATION_ANNOTATION) != null) {
                    annotationsToAdd.add(AnnotationInstance.create((DotName)CDI_PRODUCES_ANNOTATION, (AnnotationTarget)target, Collections.emptyList()));
                    DotName declaredScope = this.getScope((AnnotationTarget)methodInfo);
                    if (declaredScope == null && !methodInfo.hasAnnotation(CDI_SINGLETON_ANNOTATION)) {
                        declaredScope = CDI_SINGLETON_ANNOTATION;
                    }
                    if (declaredScope != null) {
                        annotationsToAdd.add(AnnotationInstance.create((DotName)declaredScope, (AnnotationTarget)target, Collections.emptyList()));
                    }
                    String beanName = this.getBeanNameFromBeanInstance(methodInfo.annotation(BEAN_ANNOTATION));
                    annotationsToAdd.add(AnnotationInstance.create((DotName)CDI_NAMED_ANNOTATION, (AnnotationTarget)target, Collections.singletonList(AnnotationValue.createStringValue((String)"value", (String)beanName))));
                } else if (methodInfo.hasAnnotation(AUTOWIRED_ANNOTATION)) {
                    annotationsToAdd.add(AnnotationInstance.create((DotName)CDI_INJECT_ANNOTATION, (AnnotationTarget)target, Collections.emptyList()));
                }
                for (AnnotationInstance annotation : methodInfo.annotations()) {
                    if (annotation.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER) continue;
                    if (annotation.name().equals((Object)SPRING_QUALIFIER_ANNOTATION)) {
                        AnnotationValue annotationValue = annotation.value();
                        if (annotationValue == null) continue;
                        String value = annotationValue.asString();
                        annotationsToAdd.add(AnnotationInstance.create((DotName)CDI_NAMED_ANNOTATION, (AnnotationTarget)annotation.target(), Collections.singletonList(AnnotationValue.createStringValue((String)"value", (String)value))));
                        continue;
                    }
                    if (!annotation.name().equals((Object)SPRING_VALUE_ANNOTATION)) continue;
                    this.addSpringValueAnnotations(annotation.target(), annotation, false, annotationsToAdd);
                }
            }
        }
        return annotationsToAdd;
    }

    private String getBeanNameFromStereotypeInstance(AnnotationInstance annotationInstance) {
        if (annotationInstance.target().kind() != AnnotationTarget.Kind.CLASS) {
            throw new IllegalStateException("AnnotationInstance " + annotationInstance + " is an invalid target. Only Class targets are supported");
        }
        AnnotationValue value = annotationInstance.value();
        if (value == null || value.asString().isEmpty()) {
            return this.getDefaultBeanNameFromClass(annotationInstance.target().asClass().name().toString());
        }
        return value.asString();
    }

    private String getBeanNameFromBeanInstance(AnnotationInstance annotationInstance) {
        if (annotationInstance.target().kind() != AnnotationTarget.Kind.METHOD) {
            throw new IllegalStateException("AnnotationInstance " + annotationInstance + " is an invalid target. Only Method targets are supported");
        }
        String beanName = null;
        AnnotationValue beanNameAnnotationValue = annotationInstance.value("name");
        if (beanNameAnnotationValue != null) {
            beanName = SpringDIProcessor.determineName(beanNameAnnotationValue);
        }
        if (beanName == null || beanName.isEmpty()) {
            AnnotationValue beanValueAnnotationValue = annotationInstance.value();
            if (beanNameAnnotationValue != null) {
                beanName = SpringDIProcessor.determineName(beanValueAnnotationValue);
            }
        }
        if (beanName == null || beanName.isEmpty()) {
            beanName = annotationInstance.target().asMethod().name();
        }
        return beanName;
    }

    private String getDefaultBeanNameFromClass(String className) {
        return this.decapitalize(this.getShortNameOfClass(className));
    }

    private String getShortNameOfClass(String className) {
        int lastDotIndex = className.lastIndexOf(46);
        int nameEndIndex = className.indexOf("$$");
        if (nameEndIndex == -1) {
            nameEndIndex = className.length();
        }
        String shortName = className.substring(lastDotIndex + 1, nameEndIndex);
        shortName = shortName.replace('$', '.');
        return shortName;
    }

    private String decapitalize(String name) {
        if (name != null && name.length() != 0) {
            if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
                return name;
            }
            char[] chars = name.toCharArray();
            chars[0] = Character.toLowerCase(chars[0]);
            return new String(chars);
        }
        return name;
    }

    private void addSpringValueAnnotations(AnnotationTarget target, AnnotationInstance annotation, boolean addInject, Set<AnnotationInstance> annotationsToAdd) {
        AnnotationValue annotationValue = annotation.value();
        if (annotationValue == null) {
            return;
        }
        String defaultValue = null;
        String propertyName = annotationValue.asString().replace("${", "").replace("}", "");
        if (propertyName.contains(":")) {
            int index = propertyName.indexOf(58);
            if (index < propertyName.length() - 1) {
                defaultValue = propertyName.substring(index + 1);
            }
            propertyName = propertyName.substring(0, index);
        }
        ArrayList<AnnotationValue> annotationValues = new ArrayList<AnnotationValue>();
        annotationValues.add(AnnotationValue.createStringValue((String)"name", (String)propertyName));
        if (defaultValue != null && !defaultValue.isEmpty()) {
            annotationValues.add(AnnotationValue.createStringValue((String)"defaultValue", (String)defaultValue));
        }
        annotationsToAdd.add(AnnotationInstance.create((DotName)MP_CONFIG_PROPERTY_ANNOTATION, (AnnotationTarget)target, annotationValues));
        if (addInject) {
            annotationsToAdd.add(AnnotationInstance.create((DotName)CDI_INJECT_ANNOTATION, (AnnotationTarget)target, Collections.emptyList()));
        }
    }

    private static String determineName(AnnotationValue annotationValue) {
        if (annotationValue.kind() == AnnotationValue.Kind.ARRAY) {
            return annotationValue.asStringArray()[0];
        }
        if (annotationValue.kind() == AnnotationValue.Kind.STRING) {
            return annotationValue.asString();
        }
        return null;
    }

    private DotName validateScope(ClassInfo clazz, Set<DotName> scopes, Set<DotName> scopeStereotypes) {
        int size = scopes.size();
        switch (size) {
            case 0: {
                return CDI_SINGLETON_ANNOTATION;
            }
            case 1: {
                return scopes.iterator().next();
            }
        }
        throw new DefinitionException("Components annotated with multiple conflicting scopes must declare an explicit @Scope. " + clazz.name() + " declares scopes: " + scopes.stream().map(DotName::toString).collect(Collectors.joining(", ")) + " through the stereotypes: " + scopeStereotypes.stream().map(DotName::toString).collect(Collectors.joining(", ")));
    }

    private String validateName(ClassInfo clazz, Set<String> names) {
        int size = names.size();
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                return names.iterator().next();
            }
        }
        throw new DefinitionException("Component " + clazz.name() + " is annotated with multiple conflicting names: " + String.join((CharSequence)", ", names));
    }
}

