/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.test;

import io.quarkus.maven.ArtifactCoords;
import io.quarkus.registry.catalog.Platform;
import io.quarkus.registry.catalog.json.JsonCatalogMapperHelper;
import io.quarkus.registry.catalog.json.JsonPlatform;
import io.quarkus.registry.catalog.json.JsonPlatformCatalog;
import io.quarkus.registry.config.RegistryConfig;
import io.quarkus.registry.config.RegistryMavenConfig;
import io.quarkus.registry.config.RegistryMavenRepoConfig;
import io.quarkus.registry.config.RegistryNonPlatformExtensionsConfig;
import io.quarkus.registry.config.RegistryPlatformsConfig;
import io.quarkus.registry.config.json.JsonRegistriesConfig;
import io.quarkus.registry.config.json.JsonRegistryConfig;
import io.quarkus.registry.config.json.JsonRegistryMavenConfig;
import io.quarkus.registry.config.json.JsonRegistryMavenRepoConfig;
import io.quarkus.registry.config.json.JsonRegistryNonPlatformExtensionsConfig;
import io.quarkus.registry.config.json.JsonRegistryPlatformsConfig;
import io.quarkus.registry.config.json.RegistriesConfigMapperHelper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Properties;

public class RegistryClientTestHelper {
    public static void enableRegistryClientTestConfig() {
        RegistryClientTestHelper.enableRegistryClientTestConfig(System.getProperties());
    }

    public static void enableRegistryClientTestConfig(Properties properties) {
        RegistryClientTestHelper.enableRegistryClientTestConfig(Paths.get("", new String[0]).normalize().toAbsolutePath().resolve("target"), properties);
    }

    public static void enableRegistryClientTestConfig(Path outputDir, Properties properties) {
        Path toolsConfigPath = outputDir.resolve(".quarkus/config.yaml");
        Path registryRepoPath = outputDir.resolve("test-registry-repo");
        Path groupIdDir = registryRepoPath.resolve("io/quarkus/registry/test");
        RegistryClientTestHelper.generateToolsConfig(toolsConfigPath, registryRepoPath);
        RegistryClientTestHelper.generateRegistryDescriptor(groupIdDir);
        RegistryClientTestHelper.generatePlatformCatalog(groupIdDir);
        properties.setProperty("io.quarkus.maven.secondary-local-repo", registryRepoPath.toString());
        properties.setProperty("qer.config", toolsConfigPath.toString());
    }

    private static void generatePlatformCatalog(Path groupIdDir) {
        String projectVersion = System.getProperty("project.version");
        if (projectVersion == null) {
            throw new IllegalStateException("System property project.version isn't set");
        }
        Path platformsPath = groupIdDir.resolve("quarkus-platforms").resolve("1.0-SNAPSHOT").resolve("quarkus-platforms-1.0-SNAPSHOT.json");
        Path versionedPlatformsPath = groupIdDir.resolve("quarkus-platforms").resolve("1.0-SNAPSHOT").resolve("quarkus-platforms-1.0-SNAPSHOT-" + projectVersion + ".json");
        if (Files.exists(platformsPath, new LinkOption[0]) && Files.exists(versionedPlatformsPath, new LinkOption[0])) {
            return;
        }
        ArtifactCoords bom = new ArtifactCoords("io.quarkus", "quarkus-bom", null, "pom", projectVersion);
        JsonPlatformCatalog platforms = new JsonPlatformCatalog();
        platforms.setDefaultPlatform(bom);
        JsonPlatform platform = new JsonPlatform();
        platforms.addPlatform((Platform)platform);
        platform.setBom(bom);
        platform.setQuarkusCoreVersion(projectVersion);
        try {
            JsonCatalogMapperHelper.serialize((Object)platforms, (Path)platformsPath);
            Files.copy(platformsPath, versionedPlatformsPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to persist registry platforms config", e);
        }
    }

    private static void generateRegistryDescriptor(Path repoGroupIdDir) {
        Path descriptorPath = repoGroupIdDir.resolve("quarkus-registry-descriptor").resolve("1.0-SNAPSHOT").resolve("quarkus-registry-descriptor-1.0-SNAPSHOT.json");
        if (Files.exists(descriptorPath, new LinkOption[0])) {
            return;
        }
        JsonRegistryConfig descriptor = new JsonRegistryConfig();
        JsonRegistryPlatformsConfig platformsConfig = new JsonRegistryPlatformsConfig();
        descriptor.setPlatforms((RegistryPlatformsConfig)platformsConfig);
        platformsConfig.setArtifact(new ArtifactCoords("io.quarkus.registry.test", "quarkus-platforms", null, "json", "1.0-SNAPSHOT"));
        JsonRegistryNonPlatformExtensionsConfig nonPlatformsConfig = new JsonRegistryNonPlatformExtensionsConfig();
        descriptor.setNonPlatformExtensions((RegistryNonPlatformExtensionsConfig)nonPlatformsConfig);
        nonPlatformsConfig.setDisabled(true);
        try {
            RegistriesConfigMapperHelper.serialize((Object)descriptor, (Path)descriptorPath);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to persist the registry descriptor", e);
        }
    }

    private static void generateToolsConfig(Path toolsConfigPath, Path registryRepoPath) {
        if (Files.exists(toolsConfigPath, new LinkOption[0])) {
            return;
        }
        JsonRegistryConfig registryConfig = new JsonRegistryConfig();
        registryConfig.setId("test.registry.quarkus.io");
        JsonRegistryMavenConfig mavenConfig = new JsonRegistryMavenConfig();
        registryConfig.setMaven((RegistryMavenConfig)mavenConfig);
        JsonRegistryMavenRepoConfig repoConfig = new JsonRegistryMavenRepoConfig();
        mavenConfig.setRepository((RegistryMavenRepoConfig)repoConfig);
        try {
            repoConfig.setUrl(registryRepoPath.toUri().toURL().toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Failed to translate a path to url", e);
        }
        JsonRegistriesConfig toolsConfig = new JsonRegistriesConfig();
        toolsConfig.addRegistry((RegistryConfig)registryConfig);
        toolsConfig.setDebug(true);
        try {
            RegistriesConfigMapperHelper.serialize((Object)toolsConfig, (Path)toolsConfigPath);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to persist the tools config", e);
        }
    }

    public static void disableRegistryClientTestConfig() {
        RegistryClientTestHelper.disableRegistryClientTestConfig(System.getProperties());
    }

    public static void disableRegistryClientTestConfig(Properties properties) {
        properties.remove("io.quarkus.maven.secondary-local-repo");
        properties.remove("qer.config");
    }
}

