/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.kubernetes.client;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;

public abstract class AbstractKubernetesTestResource<T, C extends KubernetesClient>
implements QuarkusTestResourceLifecycleManager {
    protected T server;

    public Map<String, String> start() {
        HashMap<String, String> systemProps = new HashMap<String, String>();
        systemProps.put("kubernetes.trust.certificates", "true");
        systemProps.put("quarkus.tls.trust-all", "true");
        systemProps.put("kubernetes.auth.tryKubeConfig", "false");
        systemProps.put("kubernetes.auth.tryServiceAccount", "false");
        systemProps.put("kubernetes.namespace", "test");
        systemProps.put("http2.disable", "true");
        this.server = this.createServer();
        this.initServer();
        systemProps.put("kubernetes.master", this.getClient().getConfiguration().getMasterUrl());
        this.configureServer();
        for (Map.Entry entry : systemProps.entrySet()) {
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return systemProps;
    }

    protected abstract C getClient();

    protected void configureServer() {
    }

    protected void initServer() {
    }

    protected abstract T createServer();

    protected boolean useHttps() {
        return Boolean.getBoolean("quarkus.kubernetes-client.test.https");
    }

    public void inject(QuarkusTestResourceLifecycleManager.TestInjector testInjector) {
        testInjector.injectIntoFields(this.server, (Predicate)new QuarkusTestResourceLifecycleManager.TestInjector.AnnotatedAndMatchesType(this.getInjectionAnnotation(), this.getInjectedClass()));
    }

    protected abstract Class<?> getInjectedClass();

    protected abstract Class<? extends Annotation> getInjectionAnnotation();
}

