/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.Defaults;
import de.flapdoodle.embed.mongo.config.ImmutableMongodConfig;
import de.flapdoodle.embed.mongo.config.MongoCmdOptions;
import de.flapdoodle.embed.mongo.config.MongodConfig;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.ImmutableRuntimeConfig;
import de.flapdoodle.embed.process.config.RuntimeConfig;
import de.flapdoodle.embed.process.config.process.ProcessOutput;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.runtime.Network;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jboss.logging.Logger;

public class MongoReplicaSetTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = Logger.getLogger(MongoReplicaSetTestResource.class);
    private static List<MongodExecutable> MONGOS = new ArrayList<MongodExecutable>();

    public Map<String, String> start() {
        try {
            Class.forName("sun.net.ext.ExtendedSocketOptions", true, ClassLoader.getSystemClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            ArrayList<MongodConfig> configs = new ArrayList<MongodConfig>();
            for (int i = 0; i < 2; ++i) {
                int port = 27017 + i;
                configs.add(MongoReplicaSetTestResource.buildMongodConfiguration("localhost", port, true));
            }
            configs.forEach(config -> {
                MongodExecutable exec = this.getMongodExecutable((MongodConfig)config);
                MONGOS.add(exec);
                try {
                    exec.start();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Unable to start the mongo instance", (Throwable)e);
                }
            });
            MongoReplicaSetTestResource.initializeReplicaSet(configs);
            return Collections.emptyMap();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private MongodExecutable getMongodExecutable(MongodConfig config) {
        try {
            return this.doGetExecutable(config);
        }
        catch (Exception e) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.doGetExecutable(config);
        }
    }

    private MongodExecutable doGetExecutable(MongodConfig config) {
        ImmutableRuntimeConfig runtimeConfig = Defaults.runtimeConfigFor((Command)Command.MongoD).processOutput((ProcessOutput)ProcessOutput.builder().output(Processors.silent()).error(Processors.silent()).commands(Processors.silent()).build()).build();
        return (MongodExecutable)MongodStarter.getInstance((RuntimeConfig)runtimeConfig).prepare((ExecutableProcessConfig)config);
    }

    public void stop() {
        MONGOS.forEach(mongod -> {
            try {
                mongod.stop();
            }
            catch (Exception e) {
                LOGGER.error((Object)"Unable to stop MongoDB", (Throwable)e);
            }
        });
    }

    private static void initializeReplicaSet(List<MongodConfig> mongodConfigList) throws UnknownHostException {
        String arbitrerAddress = "mongodb://" + mongodConfigList.get(0).net().getServerAddress().getHostName() + ":" + mongodConfigList.get(0).net().getPort();
        MongoClientSettings mo = MongoClientSettings.builder().applyConnectionString(new ConnectionString(arbitrerAddress)).build();
        try (MongoClient mongo = MongoClients.create((MongoClientSettings)mo);){
            MongoDatabase mongoAdminDB = mongo.getDatabase("admin");
            Document cr = mongoAdminDB.runCommand((Bson)new Document("isMaster", (Object)1));
            LOGGER.infof("isMaster: %s", (Object)cr);
            Document rsConfiguration = MongoReplicaSetTestResource.buildReplicaSetConfiguration(mongodConfigList);
            LOGGER.infof("replSetSettings: %s", (Object)rsConfiguration);
            cr = mongoAdminDB.runCommand((Bson)new Document("replSetInitiate", (Object)rsConfiguration));
            LOGGER.infof("replSetInitiate: %s", (Object)cr);
            Awaitility.await().pollInterval(100L, TimeUnit.MILLISECONDS).atMost(1L, TimeUnit.MINUTES).until(() -> {
                Document result = mongoAdminDB.runCommand((Bson)new Document("replSetGetStatus", (Object)1));
                LOGGER.infof("replSetGetStatus: %s", (Object)result);
                return !MongoReplicaSetTestResource.isReplicaSetStarted(result);
            });
        }
    }

    private static Document buildReplicaSetConfiguration(List<MongodConfig> configList) throws UnknownHostException {
        Document replicaSetSetting = new Document();
        replicaSetSetting.append("_id", (Object)"test001");
        ArrayList<Document> members = new ArrayList<Document>();
        int i = 0;
        for (MongodConfig mongoConfig : configList) {
            members.add(new Document().append("_id", (Object)i++).append("host", (Object)(mongoConfig.net().getServerAddress().getHostName() + ":" + mongoConfig.net().getPort())));
        }
        replicaSetSetting.append("members", members);
        return replicaSetSetting;
    }

    private static boolean isReplicaSetStarted(Document setting) {
        if (!setting.containsKey((Object)"members")) {
            return false;
        }
        List members = (List)setting.get((Object)"members", List.class);
        for (Document member : members) {
            LOGGER.infof("replica set member %s", (Object)member);
            int state = member.getInteger((Object)"state");
            LOGGER.infof("state: %s", (Object)state);
            if (state == 1 || state == 2 || state == 7) continue;
            return false;
        }
        return true;
    }

    private static MongodConfig buildMongodConfiguration(String url, int port, boolean configureReplicaSet) throws IOException {
        try {
            Class.forName("sun.net.ext.ExtendedSocketOptions", true, ClassLoader.getSystemClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ImmutableMongodConfig.Builder builder = MongodConfig.builder().version((IFeatureAwareVersion)Version.Main.V4_0).net(new Net(url, port, Network.localhostIsIPv6()));
        if (configureReplicaSet) {
            builder.putArgs("--replSet", "test001");
            builder.cmdOptions((MongoCmdOptions)MongoCmdOptions.builder().syncDelay(10).useSmallFiles(true).useNoJournal(false).build());
        }
        return builder.build();
    }
}

