/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.mongodb;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.Defaults;
import de.flapdoodle.embed.mongo.config.ImmutableMongodConfig;
import de.flapdoodle.embed.mongo.config.MongoCmdOptions;
import de.flapdoodle.embed.mongo.config.MongodConfig;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.ImmutableRuntimeConfig;
import de.flapdoodle.embed.process.config.RuntimeConfig;
import de.flapdoodle.embed.process.config.process.ProcessOutput;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.runtime.Network;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.jboss.logging.Logger;

public class MongoTestResource
implements QuarkusTestResourceLifecycleManager {
    public static final String PORT = "port";
    public static final String VERSION = "version";
    private static final int DEFAULT_PORT = 27017;
    private static MongodExecutable MONGO;
    private static final Logger LOGGER;
    private Integer port;
    private IFeatureAwareVersion version;

    public void init(Map<String, String> initArgs) {
        this.port = Optional.ofNullable(initArgs.get(PORT)).map(Integer::parseInt).orElse(27017);
        this.version = (IFeatureAwareVersion)Optional.ofNullable(initArgs.get(VERSION)).map(versionStr -> {
            try {
                return Version.valueOf((String)versionStr);
            }
            catch (IllegalArgumentException e) {
                try {
                    return Version.Main.valueOf((String)versionStr);
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException(String.format("Unable to convert %s to a known Mongo version", versionStr));
                }
            }
        }).orElse((Enum)Version.Main.V4_0);
    }

    public Map<String, String> start() {
        try {
            Class.forName("sun.net.ext.ExtendedSocketOptions", true, ClassLoader.getSystemClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            LOGGER.infof("Starting Mongo %s on port %s", (Object)this.version, (Object)this.port);
            ImmutableMongodConfig config = MongodConfig.builder().version(this.version).net(new Net(this.port.intValue(), Network.localhostIsIPv6())).cmdOptions((MongoCmdOptions)MongoCmdOptions.builder().useNoJournal(false).build()).build();
            MONGO = this.getMongodExecutable((MongodConfig)config);
            try {
                MONGO.start();
            }
            catch (Exception e) {
                Thread.sleep(1000L);
                MONGO.start();
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        return Collections.emptyMap();
    }

    private MongodExecutable getMongodExecutable(MongodConfig config) {
        try {
            return this.doGetExecutable(config);
        }
        catch (Exception e) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.doGetExecutable(config);
        }
    }

    private MongodExecutable doGetExecutable(MongodConfig config) {
        ImmutableRuntimeConfig runtimeConfig = Defaults.runtimeConfigFor((Command)Command.MongoD).processOutput((ProcessOutput)ProcessOutput.builder().output(Processors.silent()).error(Processors.silent()).commands(Processors.silent()).build()).build();
        return (MongodExecutable)MongodStarter.getInstance((RuntimeConfig)runtimeConfig).prepare((ExecutableProcessConfig)config);
    }

    public void stop() {
        if (MONGO != null) {
            MONGO.stop();
        }
    }

    static {
        LOGGER = Logger.getLogger(MongoTestResource.class);
    }
}

