/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.oidc.server;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.responsetemplating.ResponseTemplateTransformer;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.google.common.collect.ImmutableSet;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import io.smallrye.jwt.build.Jwt;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class OidcWiremockTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOG = Logger.getLogger(OidcWiremockTestResource.class);
    private static final String TOKEN_ISSUER = System.getProperty("quarkus.test.oidc.token.issuer", "https://server.example.com");
    private static final String TOKEN_AUDIENCE = System.getProperty("quarkus.test.oidc.token.audience", "https://server.example.com");
    private static final String TOKEN_USER_ROLES = System.getProperty("quarkus.test.oidc.token.user-roles", "user");
    private static final String TOKEN_ADMIN_ROLES = System.getProperty("quarkus.test.oidc.token.admin-roles", "user,admin");
    private WireMockServer server;

    public Map<String, String> start() {
        this.server = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().extensions(new Extension[]{new ResponseTemplateTransformer(false)}).dynamicPort());
        this.server.start();
        this.server.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/auth/realms/quarkus/.well-known/openid-configuration")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\n    \"jwks_uri\": \"" + this.server.baseUrl() + "/auth/realms/quarkus/protocol/openid-connect/certs\",\n    \"token_introspection_endpoint\": \"" + this.server.baseUrl() + "/auth/realms/quarkus/protocol/openid-connect/token/introspect\",\n    \"authorization_endpoint\": \"" + this.server.baseUrl() + "/auth/realms/quarkus\",    \"token_endpoint\": \"" + this.server.baseUrl() + "/auth/realms/quarkus/token\",    \"issuer\" : \"" + TOKEN_ISSUER + "\",    \"introspection_endpoint\": \"" + this.server.baseUrl() + "/auth/realms/quarkus/protocol/openid-connect/token/introspect\"}")));
        this.server.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/auth/realms/quarkus/protocol/openid-connect/certs")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\n  \"keys\" : [\n    {\n      \"kid\": \"1\",\n      \"kty\":\"RSA\",\n      \"n\":\"iJw33l1eVAsGoRlSyo-FCimeOc-AaZbzQ2iESA3Nkuo3TFb1zIkmt0kzlnWVGt48dkaIl13Vdefh9hqw_r9yNF8xZqX1fp0PnCWc5M_TX_ht5fm9y0TpbiVmsjeRMWZn4jr3DsFouxQ9aBXUJiu26V0vd2vrECeeAreFT4mtoHY13D2WVeJvboc5mEJcp50JNhxRCJ5UkY8jR_wfUk2Tzz4-fAj5xQaBccXnqJMu_1C6MjoCEiB7G1d13bVPReIeAGRKVJIF6ogoCN8JbrOhc_48lT4uyjbgnd24beatuKWodmWYhactFobRGYo5551cgMe8BoxpVQ4to30cGA0qjQ\",\n      \"e\":\"AQAB\"\n    }\n  ]\n}")));
        this.defineValidIntrospectionMockTokenStubForUserWithRoles("alice", (Set<String>)ImmutableSet.copyOf(this.getUserRoles()));
        this.defineValidIntrospectionMockTokenStubForUserWithRoles("admin", (Set<String>)ImmutableSet.copyOf(this.getAdminRoles()));
        this.defineInvalidIntrospectionMockTokenStubForUserWithRoles("expired", Collections.emptySet());
        this.defineCodeFlowAuthorizationMockTokenStub();
        this.server.stubFor(WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/auth/realms/quarkus")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"text/html"}).withBody("<html>\n<body>\n <form action=\"/login\" name=\"form\">\n  <input type=\"text\" id=\"username\" name=\"username\"/>\n  <input type=\"password\" id=\"password\" name=\"password\"/>\n  <input type=\"hidden\" id=\"state\" name=\"state\" value=\"{{request.query.state}}\"/>\n  <input type=\"hidden\" id=\"redirect_uri\" name=\"redirect_uri\" value=\"{{request.query.redirect_uri}}\"/>\n  <input type=\"submit\" id=\"login\" value=\"login\"/>\n</form>\n</body>\n</html> ").withTransformers(new String[]{"response-template"})));
        this.server.stubFor(WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/login")).willReturn(WireMock.aResponse().withHeader("Location", new String[]{"{{request.query.redirect_uri}}?state={{request.query.state}}&code=58af24f2-9093-4674-a431-4a9d66be719c.50437113-cd78-48a2-838e-b936fe458c5d.0ac5df91-e044-4051-bd03-106a3a5fb9cc"}).withStatus(302).withTransformers(new String[]{"response-template"})));
        LOG.infof("Keycloak started in mock mode: %s", (Object)this.server.baseUrl());
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("keycloak.url", this.server.baseUrl() + "/auth");
        return conf;
    }

    private void defineValidIntrospectionMockTokenStubForUserWithRoles(String user, Set<String> roles) {
        this.server.stubFor(WireMock.post((String)"/auth/realms/quarkus/protocol/openid-connect/token/introspect").withRequestBody((ContentPattern)WireMock.matching((String)("token=" + user + "&token_type_hint=access_token"))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\"active\":true,\"scope\":\"" + roles.stream().collect(Collectors.joining(" ")) + "\",\"username\":\"" + user + "\",\"iat\":1,\"exp\":999999999999,\"expires_in\":999999999999,\"client_id\":\"my_client_id\"}")));
    }

    private void defineInvalidIntrospectionMockTokenStubForUserWithRoles(String user, Set<String> roles) {
        this.server.stubFor(WireMock.post((String)"/auth/realms/quarkus/protocol/openid-connect/token/introspect").withRequestBody((ContentPattern)WireMock.matching((String)("token=" + user + "&token_type_hint=access_token"))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\"active\":true,\"scope\":\"" + roles.stream().collect(Collectors.joining(" ")) + "\",\"username\":\"" + user + "\",\"iat\":1562315654,\"exp\":1,\"expires_in\":1,\"client_id\":\"my_client_id\"}")));
    }

    private void defineCodeFlowAuthorizationMockTokenStub() {
        this.server.stubFor(WireMock.post((String)"/auth/realms/quarkus/token").withRequestBody((ContentPattern)WireMock.containing((String)"authorization_code")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\n  \"access_token\": \"" + this.getAccessToken("alice", this.getAdminRoles()) + "\",\n  \"refresh_token\": \"07e08903-1263-4dd1-9fd1-4a59b0db5283\",\n  \"id_token\": \"" + this.getIdToken("alice", this.getAdminRoles()) + "\"\n}")));
    }

    private Set<String> getAdminRoles() {
        return new HashSet<String>(Arrays.asList(TOKEN_ADMIN_ROLES.split(",")));
    }

    private Set<String> getUserRoles() {
        return new HashSet<String>(Arrays.asList(TOKEN_USER_ROLES.split(",")));
    }

    private String getAccessToken(String userName, Set<String> groups) {
        return this.generateJwtToken(userName, groups);
    }

    private String getIdToken(String userName, Set<String> groups) {
        return this.generateJwtToken(userName, groups);
    }

    private String generateJwtToken(String userName, Set<String> groups) {
        return Jwt.preferredUserName((String)userName).groups(groups).issuer(TOKEN_ISSUER).audience(TOKEN_AUDIENCE).jws().keyId("1").sign("privateKey.jwk");
    }

    public synchronized void stop() {
        if (this.server != null) {
            this.server.stop();
            LOG.info((Object)"Keycloak was shut down");
            this.server = null;
        }
    }
}

