/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.security;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.SecurityIdentityAssociation;
import io.quarkus.test.security.DelegateSecurityIdentityAssociation;
import io.smallrye.mutiny.Uni;
import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;

@Alternative
@Priority(value=3000)
@ApplicationScoped
public class TestIdentityAssociation
extends SecurityIdentityAssociation {
    volatile SecurityIdentity testIdentity;
    @Inject
    DelegateSecurityIdentityAssociation delegate;

    @PostConstruct
    public void check() {
        if (LaunchMode.current() != LaunchMode.TEST) {
            throw new RuntimeException("TestAuthController can only be used in tests");
        }
    }

    public SecurityIdentity getTestIdentity() {
        return this.testIdentity;
    }

    public TestIdentityAssociation setTestIdentity(SecurityIdentity testIdentity) {
        this.testIdentity = testIdentity;
        return this;
    }

    public void setIdentity(SecurityIdentity identity) {
        this.delegate.setIdentity(identity);
    }

    public void setIdentity(Uni<SecurityIdentity> identity) {
        this.delegate.setIdentity(identity);
    }

    public Uni<SecurityIdentity> getDeferredIdentity() {
        if (this.testIdentity != null) {
            return Uni.createFrom().item((Object)this.testIdentity);
        }
        return this.delegate.getDeferredIdentity();
    }

    public SecurityIdentity getIdentity() {
        SecurityIdentity underlying = this.delegate.getIdentity();
        if (underlying.isAnonymous() && this.testIdentity != null) {
            return this.testIdentity;
        }
        return this.delegate.getIdentity();
    }
}

