/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.certs;

import io.smallrye.certs.CertificateFiles;
import io.smallrye.certs.Format;
import java.nio.file.Path;

public final class JksCertificateFiles
implements CertificateFiles {
    private final Path root;
    private final String name;
    private final boolean client;
    private final String password;
    private final Path keyStoreFile;
    private final Path trustStoreFile;
    private final Path clientKeyStoreFile;
    private final Path serverTrustStoreFile;

    public JksCertificateFiles(Path root, String name, boolean client, String password) {
        this.root = root;
        this.name = name;
        this.client = client;
        this.password = password;
        this.keyStoreFile = root.resolve(name + "-keystore." + this.format().extension());
        this.trustStoreFile = root.resolve(name + (client ? "-client" : "") + "-truststore." + this.format().extension());
        this.clientKeyStoreFile = root.resolve(name + "-client-keystore." + this.format().extension());
        this.serverTrustStoreFile = root.resolve(name + "-server-truststore." + this.format().extension());
    }

    @Override
    public Format format() {
        return Format.JKS;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Path root() {
        return this.root;
    }

    @Override
    public boolean client() {
        return this.client;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public Path trustStore() {
        return this.client ? this.serverTrustStoreFile : this.trustStoreFile;
    }

    public String toString() {
        return "JksCertificateFiles{root=" + this.root + ", name='" + this.name + "', client=" + this.client + ", password='" + this.password + "'}";
    }

    public Path keyStoreFile() {
        return this.keyStoreFile;
    }

    public Path trustStoreFile() {
        return this.trustStoreFile;
    }

    public Path clientKeyStoreFile() {
        return this.clientKeyStoreFile;
    }

    public Path serverTrustStoreFile() {
        return this.serverTrustStoreFile;
    }
}

