/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tls.cli;

import io.quarkus.tls.cli.Constants;
import io.smallrye.certs.ca.CaGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="generate-quarkus-ca", mixinStandardHelpOptions=true, description={"Generate Quarkus Dev CA certificate and private key."})
public class GenerateCACommand
implements Callable<Integer> {
    @CommandLine.Option(names={"-i", "--install"}, description={"Install the generated CA into the system keychain."}, defaultValue="false")
    boolean install;
    @CommandLine.Option(names={"-t", "--truststore"}, description={"Generate a PKCS12 (`.p12`) truststore containing the generated CA."}, defaultValue="false")
    boolean truststore;
    @CommandLine.Option(names={"-r", "--renew"}, description={"Update certificate if already created."}, defaultValue="false")
    boolean renew;
    static System.Logger LOGGER = System.getLogger("generate-quarkus-ca");

    @Override
    public Integer call() throws Exception {
        LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd25 Generating Quarkus Dev CA certificate...");
        if (!Constants.BASE_DIR.exists()) {
            Constants.BASE_DIR.mkdirs();
        }
        if (Constants.CA_FILE.exists() && !this.renew && !this.hasExpired()) {
            LOGGER.log(System.Logger.Level.INFO, "\u2705 Quarkus Dev CA certificate already exists and has not yet expired. Use --renew to update.");
            return 0;
        }
        String username = System.getProperty("user.name", "");
        CaGenerator generator = new CaGenerator(Constants.CA_FILE, Constants.PK_FILE, Constants.KEYSTORE_FILE, "quarkus");
        generator.generate("quarkus-dev-root-ca", "Quarkus Development (" + username + ")", "Quarkus Development", "home", "world", "universe");
        if (this.install) {
            LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd25 Installing the CA certificate in the system truststore...");
            generator.installToSystem();
        }
        if (this.truststore) {
            LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd25 Generating p12 truststore...");
            File ts = new File("quarkus-ca-truststore.p12");
            generator.generateTrustStore(ts);
            LOGGER.log(System.Logger.Level.INFO, "\u2705 Truststore generated successfully.");
        }
        LOGGER.log(System.Logger.Level.INFO, "\u2705 Quarkus Development CA generated and installed");
        return 0;
    }

    private boolean hasExpired() throws Exception {
        X509Certificate cert = GenerateCACommand.getCertificateFromPKCS12();
        try {
            cert.checkValidity();
        }
        catch (Exception e) {
            LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd25 Certificate has expired. Renewing...");
            return true;
        }
        return false;
    }

    private static X509Certificate getCertificateFromPKCS12() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        try (FileInputStream fis = new FileInputStream(Constants.KEYSTORE_FILE);){
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            keystore.load(fis, "quarkus".toCharArray());
            Certificate cert = keystore.getCertificate("ca");
            if (cert == null) {
                throw new KeyStoreException("No certificate found with alias: ca");
            }
            X509Certificate x509Certificate = (X509Certificate)cert;
            return x509Certificate;
        }
    }
}

