/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.ContextRegistrarBuildItem;
import io.quarkus.arc.processor.ContextRegistrar;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentConfigFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ObjectSubstitutionBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.substrate.RuntimeReinitializedClassBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateConfigBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateResourceBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.kubernetes.spi.KubernetesPortBuildItem;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.undertow.deployment.FilterBuildItem;
import io.quarkus.undertow.deployment.HttpHandlerWrapperBuildItem;
import io.quarkus.undertow.deployment.ListenerBuildItem;
import io.quarkus.undertow.deployment.ServletBuildItem;
import io.quarkus.undertow.deployment.ServletContextAttributeBuildItem;
import io.quarkus.undertow.deployment.ServletDeploymentManagerBuildItem;
import io.quarkus.undertow.deployment.ServletExtensionBuildItem;
import io.quarkus.undertow.deployment.ServletInitParamBuildItem;
import io.quarkus.undertow.deployment.UndertowBuildItem;
import io.quarkus.undertow.deployment.WebMetadataBuildItem;
import io.quarkus.undertow.runtime.HttpConfig;
import io.quarkus.undertow.runtime.HttpSessionContext;
import io.quarkus.undertow.runtime.ServletProducer;
import io.quarkus.undertow.runtime.ServletSecurityInfoProxy;
import io.quarkus.undertow.runtime.ServletSecurityInfoSubstitution;
import io.quarkus.undertow.runtime.UndertowDeploymentTemplate;
import io.undertow.Undertow;
import io.undertow.servlet.api.HttpMethodSecurityInfo;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletSecurityInfo;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.handlers.DefaultServlet;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamReader;
import org.jboss.annotation.javaee.Descriptions;
import org.jboss.annotation.javaee.DisplayNames;
import org.jboss.annotation.javaee.Icons;
import org.jboss.builder.item.BuildItem;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.DescriptionImpl;
import org.jboss.metadata.javaee.spec.DescriptionsImpl;
import org.jboss.metadata.javaee.spec.DisplayNameImpl;
import org.jboss.metadata.javaee.spec.DisplayNamesImpl;
import org.jboss.metadata.javaee.spec.IconImpl;
import org.jboss.metadata.javaee.spec.IconsImpl;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.spec.RunAsMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.parser.servlet.WebMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.property.PropertyReplacers;
import org.jboss.metadata.web.spec.AnnotationMetaData;
import org.jboss.metadata.web.spec.AnnotationsMetaData;
import org.jboss.metadata.web.spec.DispatcherType;
import org.jboss.metadata.web.spec.EmptyRoleSemanticType;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.metadata.web.spec.HttpMethodConstraintMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.MultipartConfigMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.metadata.web.spec.ServletSecurityMetaData;
import org.jboss.metadata.web.spec.ServletsMetaData;
import org.jboss.metadata.web.spec.WebMetaData;

public class UndertowBuildStep {
    public static final DotName WEB_FILTER = DotName.createSimple((String)WebFilter.class.getName());
    public static final DotName WEB_LISTENER = DotName.createSimple((String)WebListener.class.getName());
    public static final DotName WEB_SERVLET = DotName.createSimple((String)WebServlet.class.getName());
    public static final DotName RUN_AS = DotName.createSimple((String)RunAs.class.getName());
    public static final DotName DECLARE_ROLES = DotName.createSimple((String)DeclareRoles.class.getName());
    public static final DotName MULTIPART_CONFIG = DotName.createSimple((String)MultipartConfig.class.getName());
    public static final DotName SERVLET_SECURITY = DotName.createSimple((String)ServletSecurity.class.getName());
    public static final String WEB_XML = "META-INF/web.xml";
    @Inject
    CombinedIndexBuildItem combinedIndexBuildItem;

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public ServiceStartBuildItem boot(UndertowDeploymentTemplate template, ServletDeploymentManagerBuildItem servletDeploymentManagerBuildItem, List<HttpHandlerWrapperBuildItem> wrappers, ShutdownContextBuildItem shutdown, Consumer<UndertowBuildItem> undertowProducer, LaunchModeBuildItem launchMode, HttpConfig config) throws Exception {
        RuntimeValue ut = template.startUndertow((ShutdownContext)shutdown, servletDeploymentManagerBuildItem.getDeploymentManager(), config, wrappers.stream().map(HttpHandlerWrapperBuildItem::getValue).collect(Collectors.toList()), launchMode.getLaunchMode());
        undertowProducer.accept(new UndertowBuildItem((RuntimeValue<Undertow>)ut));
        return new ServiceStartBuildItem("undertow");
    }

    @BuildStep
    void integrateCdi(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ContextRegistrarBuildItem> contextRegistrars, BuildProducer<ListenerBuildItem> listeners) {
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{ServletProducer.class}));
        contextRegistrars.produce((BuildItem)new ContextRegistrarBuildItem(new ContextRegistrar(){

            public void register(ContextRegistrar.RegistrationContext registrationContext) {
                registrationContext.configure(SessionScoped.class).normal().contextClass(HttpSessionContext.class).done();
            }
        }));
        listeners.produce((BuildItem)new ListenerBuildItem(HttpSessionContext.class.getName()));
    }

    @BuildStep
    SubstrateConfigBuildItem config() {
        return SubstrateConfigBuildItem.builder().addRuntimeInitializedClass("io.undertow.server.protocol.ajp.AjpServerResponseConduit").addRuntimeInitializedClass("io.undertow.server.protocol.ajp.AjpServerRequestConduit").build();
    }

    @BuildStep
    void runtimeReinit(BuildProducer<RuntimeReinitializedClassBuildItem> producer) {
        producer.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.wildfly.common.net.HostName"));
        producer.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.wildfly.common.os.Process"));
    }

    @BuildStep
    HotDeploymentConfigFileBuildItem configFile() {
        return new HotDeploymentConfigFileBuildItem(WEB_XML);
    }

    @BuildStep
    WebMetadataBuildItem createWebMetadata(ApplicationArchivesBuildItem applicationArchivesBuildItem, Consumer<AdditionalBeanBuildItem> additionalBeanBuildItemConsumer) throws Exception {
        WebMetaData result;
        Path webXml = applicationArchivesBuildItem.getRootArchive().getChildPath(WEB_XML);
        if (webXml != null) {
            HashSet<String> additionalBeans = new HashSet<String>();
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            MetaDataElementParser.DTDInfo dtdInfo = new MetaDataElementParser.DTDInfo();
            inputFactory.setXMLResolver((XMLResolver)dtdInfo);
            try (FileInputStream in = new FileInputStream(webXml.toFile());){
                XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(in);
                result = WebMetaDataParser.parse((XMLStreamReader)xmlReader, (MetaDataElementParser.DTDInfo)dtdInfo, (PropertyReplacer)PropertyReplacers.noop());
            }
            if (result.getServlets() != null) {
                for (ServletMetaData i : result.getServlets()) {
                    additionalBeans.add(i.getServletClass());
                }
            }
            if (result.getFilters() != null) {
                for (ServletMetaData i : result.getFilters()) {
                    additionalBeans.add(i.getFilterClass());
                }
            }
            if (result.getListeners() != null) {
                for (ServletMetaData i : result.getListeners()) {
                    additionalBeans.add(i.getListenerClass());
                }
            }
            additionalBeanBuildItemConsumer.accept(AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(additionalBeans).build());
        } else {
            result = new WebMetaData();
        }
        return new WebMetadataBuildItem(result);
    }

    @BuildStep
    public void kubernetes(HttpConfig config, BuildProducer<KubernetesPortBuildItem> portProducer) {
        portProducer.produce((BuildItem)new KubernetesPortBuildItem(config.port, "http"));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    public ServletDeploymentManagerBuildItem build(ApplicationArchivesBuildItem applicationArchivesBuildItem, List<ServletBuildItem> servlets, List<FilterBuildItem> filters, List<ListenerBuildItem> listeners, List<ServletInitParamBuildItem> initParams, List<ServletContextAttributeBuildItem> contextParams, UndertowDeploymentTemplate template, RecorderContext context, List<ServletExtensionBuildItem> extensions, BeanContainerBuildItem bc, WebMetadataBuildItem webMetadataBuildItem, BuildProducer<ObjectSubstitutionBuildItem> substitutions, Consumer<ReflectiveClassBuildItem> reflectiveClasses, LaunchModeBuildItem launchMode, ShutdownContextBuildItem shutdownContext) throws Exception {
        RuntimeValue sref;
        HashMap params;
        ObjectSubstitutionBuildItem.Holder holder = new ObjectSubstitutionBuildItem.Holder(ServletSecurityInfo.class, ServletSecurityInfoProxy.class, ServletSecurityInfoSubstitution.class);
        substitutions.produce((BuildItem)new ObjectSubstitutionBuildItem(holder));
        reflectiveClasses.accept(new ReflectiveClassBuildItem(false, false, new String[]{DefaultServlet.class.getName(), "io.undertow.server.protocol.http.HttpRequestParser$$generated"}));
        final HashSet knownFiles = new HashSet();
        final HashSet knownDirectories = new HashSet();
        for (ApplicationArchive i2 : applicationArchivesBuildItem.getAllApplicationArchives()) {
            final Path resource = i2.getChildPath("META-INF/resources");
            if (resource == null || !Files.exists(resource, new LinkOption[0])) continue;
            Files.walk(resource, new FileVisitOption[0]).forEach(new Consumer<Path>(){

                @Override
                public void accept(Path path) {
                    if (resource.equals(path)) {
                        return;
                    }
                    Path rel = resource.relativize(path);
                    if (Files.isDirectory(rel, new LinkOption[0])) {
                        knownDirectories.add(rel.toString());
                    } else {
                        knownFiles.add(rel.toString());
                    }
                }
            });
        }
        RuntimeValue deployment = template.createDeployment("test", knownFiles, knownDirectories, launchMode.getLaunchMode(), (ShutdownContext)shutdownContext);
        WebMetaData webMetaData = webMetadataBuildItem.getWebMetaData();
        IndexView index = this.combinedIndexBuildItem.getIndex();
        this.processAnnotations(index, webMetaData);
        if (webMetaData.getServlets() != null) {
            for (ServletMetaData servletMetaData : webMetaData.getServlets()) {
                reflectiveClasses.accept(new ReflectiveClassBuildItem(false, false, new String[]{servletMetaData.getServletClass()}));
                params = new HashMap();
                for (Map.Entry entry : params.entrySet()) {
                    params.put(entry.getKey(), entry.getValue());
                }
                sref = template.registerServlet(deployment, servletMetaData.getServletName(), context.classProxy(servletMetaData.getServletClass()), servletMetaData.isAsyncSupported(), servletMetaData.getLoadOnStartupInt(), bc.getValue(), params, null);
                if (servletMetaData.getInitParam() != null) {
                    for (ParamValueMetaData init : servletMetaData.getInitParam()) {
                        template.addServletInitParam(sref, init.getParamName(), init.getParamValue());
                    }
                }
                if (servletMetaData.getMultipartConfig() != null) {
                    template.setMultipartConfig(sref, servletMetaData.getMultipartConfig().getLocation(), servletMetaData.getMultipartConfig().getMaxFileSize(), servletMetaData.getMultipartConfig().getMaxRequestSize(), servletMetaData.getMultipartConfig().getFileSizeThreshold());
                }
                if (webMetaData.getAnnotations() == null) continue;
                for (AnnotationMetaData amd : webMetaData.getAnnotations()) {
                    if (amd.getClassName().equals(servletMetaData.getServletClass())) {
                        ServletSecurityMetaData ssmd = amd.getServletSecurity();
                        ServletSecurityInfo securityInfo = new ServletSecurityInfo();
                        securityInfo.setEmptyRoleSemantic(ssmd.getEmptyRoleSemantic() == EmptyRoleSemanticType.DENY ? SecurityInfo.EmptyRoleSemantic.DENY : SecurityInfo.EmptyRoleSemantic.PERMIT);
                        ((ServletSecurityInfo)securityInfo.setTransportGuaranteeType(UndertowBuildStep.transportGuaranteeType(ssmd.getTransportGuarantee()))).addRolesAllowed((Collection)ssmd.getRolesAllowed());
                        if (ssmd.getHttpMethodConstraints() != null) {
                            for (HttpMethodConstraintMetaData method : ssmd.getHttpMethodConstraints()) {
                                securityInfo.addHttpMethodSecurityInfo(((HttpMethodSecurityInfo)((HttpMethodSecurityInfo)((HttpMethodSecurityInfo)new HttpMethodSecurityInfo().setEmptyRoleSemantic(method.getEmptyRoleSemantic() == EmptyRoleSemanticType.DENY ? SecurityInfo.EmptyRoleSemantic.DENY : SecurityInfo.EmptyRoleSemantic.PERMIT)).setTransportGuaranteeType(UndertowBuildStep.transportGuaranteeType(method.getTransportGuarantee()))).addRolesAllowed((Collection)method.getRolesAllowed())).setMethod(method.getMethod()));
                            }
                        }
                        template.setSecurityInfo(sref, securityInfo);
                    }
                    if (servletMetaData.getSecurityRoleRefs() == null) continue;
                    for (SecurityRoleRefMetaData ref : servletMetaData.getSecurityRoleRefs()) {
                        template.addSecurityRoleRef(sref, ref.getRoleName(), ref.getRoleLink());
                    }
                }
            }
        }
        if (webMetaData.getServletMappings() != null) {
            for (ServletMappingMetaData servletMappingMetaData : webMetaData.getServletMappings()) {
                for (Object m : servletMappingMetaData.getUrlPatterns()) {
                    template.addServletMapping(deployment, servletMappingMetaData.getServletName(), (String)m);
                }
            }
        }
        if (webMetaData.getFilters() != null) {
            for (FilterMetaData filterMetaData : webMetaData.getFilters()) {
                reflectiveClasses.accept(new ReflectiveClassBuildItem(false, false, new String[]{filterMetaData.getFilterClass()}));
                params = new HashMap();
                for (Map.Entry entry : params.entrySet()) {
                    params.put(entry.getKey(), entry.getValue());
                }
                sref = template.registerFilter(deployment, filterMetaData.getFilterName(), context.classProxy(filterMetaData.getFilterClass()), filterMetaData.isAsyncSupported(), bc.getValue(), params, null);
                if (filterMetaData.getInitParam() == null) continue;
                for (ParamValueMetaData init : filterMetaData.getInitParam()) {
                    template.addFilterInitParam(sref, init.getParamName(), init.getParamValue());
                }
            }
        }
        if (webMetaData.getFilterMappings() != null) {
            for (FilterMappingMetaData filterMappingMetaData : webMetaData.getFilterMappings()) {
                for (Object m : filterMappingMetaData.getUrlPatterns()) {
                    if (filterMappingMetaData.getDispatchers() == null || filterMappingMetaData.getDispatchers().isEmpty()) {
                        template.addFilterURLMapping(deployment, filterMappingMetaData.getFilterName(), (String)m, javax.servlet.DispatcherType.REQUEST);
                        continue;
                    }
                    for (DispatcherType dispatcher : filterMappingMetaData.getDispatchers()) {
                        template.addFilterURLMapping(deployment, filterMappingMetaData.getFilterName(), (String)m, javax.servlet.DispatcherType.valueOf((String)dispatcher.name()));
                    }
                }
            }
        }
        if (webMetaData.getListeners() != null) {
            for (ListenerMetaData listenerMetaData : webMetaData.getListeners()) {
                reflectiveClasses.accept(new ReflectiveClassBuildItem(false, false, new String[]{listenerMetaData.getListenerClass()}));
                template.registerListener(deployment, context.classProxy(listenerMetaData.getListenerClass()), bc.getValue());
            }
        }
        for (ServletBuildItem servletBuildItem : servlets) {
            String servletClass = servletBuildItem.getServletClass();
            if (servletBuildItem.getLoadOnStartup() == 0) {
                reflectiveClasses.accept(new ReflectiveClassBuildItem(false, false, new String[]{servletBuildItem.getServletClass()}));
            }
            template.registerServlet(deployment, servletBuildItem.getName(), context.classProxy(servletClass), servletBuildItem.isAsyncSupported(), servletBuildItem.getLoadOnStartup(), bc.getValue(), servletBuildItem.getInitParams(), servletBuildItem.getInstanceFactory());
            for (String string : servletBuildItem.getMappings()) {
                template.addServletMapping(deployment, servletBuildItem.getName(), string);
            }
        }
        for (FilterBuildItem filterBuildItem : filters) {
            String filterClass = filterBuildItem.getFilterClass();
            reflectiveClasses.accept(new ReflectiveClassBuildItem(false, false, new String[]{filterClass}));
            template.registerFilter(deployment, filterBuildItem.getName(), context.classProxy(filterClass), filterBuildItem.isAsyncSupported(), bc.getValue(), filterBuildItem.getInitParams(), filterBuildItem.getInstanceFactory());
            for (FilterBuildItem.FilterMappingInfo filterMappingInfo : filterBuildItem.getMappings()) {
                if (filterMappingInfo.getMappingType() == FilterBuildItem.FilterMappingInfo.MappingType.URL) {
                    template.addFilterURLMapping(deployment, filterBuildItem.getName(), filterMappingInfo.getMapping(), filterMappingInfo.getDispatcher());
                    continue;
                }
                template.addFilterServletNameMapping(deployment, filterBuildItem.getName(), filterMappingInfo.getMapping(), filterMappingInfo.getDispatcher());
            }
        }
        for (ServletInitParamBuildItem servletInitParamBuildItem : initParams) {
            template.addServltInitParameter(deployment, servletInitParamBuildItem.getKey(), servletInitParamBuildItem.getValue());
        }
        for (ServletContextAttributeBuildItem servletContextAttributeBuildItem : contextParams) {
            template.addServletContextAttribute(deployment, servletContextAttributeBuildItem.getKey(), servletContextAttributeBuildItem.getValue());
        }
        for (ServletExtensionBuildItem servletExtensionBuildItem : extensions) {
            template.addServletExtension(deployment, servletExtensionBuildItem.getValue());
        }
        for (ListenerBuildItem listenerBuildItem : listeners) {
            reflectiveClasses.accept(new ReflectiveClassBuildItem(false, false, new String[]{listenerBuildItem.getListenerClass()}));
            template.registerListener(deployment, context.classProxy(listenerBuildItem.getListenerClass()), bc.getValue());
        }
        return new ServletDeploymentManagerBuildItem(template.bootServletContainer(deployment, bc.getValue()));
    }

    @BuildStep
    SubstrateResourceBuildItem registerSubstrateResources(final ArchiveRootBuildItem root, ApplicationArchivesBuildItem applicationArchivesBuildItem) throws IOException {
        final ArrayList res = new ArrayList();
        Path resources = applicationArchivesBuildItem.getRootArchive().getChildPath("META-INF/resources");
        if (resources != null) {
            Files.walk(resources, new FileVisitOption[0]).forEach(new Consumer<Path>(){

                @Override
                public void accept(Path path) {
                    if (!Files.isDirectory(path, new LinkOption[0])) {
                        res.add(root.getPath().relativize(path).toString());
                    }
                }
            });
        }
        return new SubstrateResourceBuildItem(res);
    }

    private void processAnnotations(IndexView index, WebMetaData metaData) {
        Collection servletSecurityAnnotations;
        Collection multipartConfigAnnotations;
        Collection declareRolesAnnotations;
        Collection runAsAnnotations;
        Collection webListenerAnnotations;
        ClassInfo classInfo;
        AnnotationTarget target;
        Collection webFilterAnnotations;
        ArrayList<String> urlPatterns;
        AnnotationValue largeIconValue2;
        AnnotationInstance[] smallIconValue;
        AnnotationValue displayNameValue;
        AnnotationValue descriptionValue;
        DescriptionGroupMetaData descriptionGroup2;
        String[] initParamValue;
        AnnotationValue initParamName;
        ParamValueMetaData initParam;
        ArrayList<ParamValueMetaData> initParams;
        AnnotationInstance[] initParamsAnnotations;
        AnnotationValue initParamsValue;
        AnnotationValue asyncSupported;
        Collection webServletAnnotations = index.getAnnotations(WEB_SERVLET);
        if (webServletAnnotations != null && webServletAnnotations.size() > 0) {
            ArrayList<ServletMappingMetaData> servletMappings;
            ServletsMetaData servlets = metaData.getServlets();
            if (servlets == null) {
                servlets = new ServletsMetaData();
                metaData.setServlets(servlets);
            }
            if ((servletMappings = metaData.getServletMappings()) == null) {
                servletMappings = new ArrayList<ServletMappingMetaData>();
                metaData.setServletMappings(servletMappings);
            }
            for (Object annotation : webServletAnnotations) {
                ServletMetaData servlet = new ServletMetaData();
                AnnotationTarget target2 = annotation.target();
                ClassInfo classInfo2 = (ClassInfo)ClassInfo.class.cast(target2);
                servlet.setServletClass(classInfo2.toString());
                AnnotationValue nameValue = annotation.value("name");
                if (nameValue == null || nameValue.asString().isEmpty()) {
                    servlet.setName(classInfo2.toString());
                } else {
                    servlet.setName(nameValue.asString());
                }
                AnnotationValue loadOnStartup = annotation.value("loadOnStartup");
                if (loadOnStartup != null && loadOnStartup.asInt() >= 0) {
                    servlet.setLoadOnStartupInt(loadOnStartup.asInt());
                }
                if ((asyncSupported = annotation.value("asyncSupported")) != null) {
                    servlet.setAsyncSupported(asyncSupported.asBoolean());
                }
                if ((initParamsValue = annotation.value("initParams")) != null && (initParamsAnnotations = initParamsValue.asNestedArray()) != null && initParamsAnnotations.length > 0) {
                    initParams = new ArrayList<ParamValueMetaData>();
                    for (AnnotationInstance initParamsAnnotation : initParamsAnnotations) {
                        Descriptions descriptions;
                        initParam = new ParamValueMetaData();
                        initParamName = initParamsAnnotation.value("name");
                        initParamValue = initParamsAnnotation.value();
                        AnnotationValue initParamDescription = initParamsAnnotation.value("description");
                        initParam.setParamName(initParamName.asString());
                        initParam.setParamValue(initParamValue.asString());
                        if (initParamDescription != null && (descriptions = this.getDescription(initParamDescription.asString())) != null) {
                            initParam.setDescriptions(descriptions);
                        }
                        initParams.add(initParam);
                    }
                    servlet.setInitParam(initParams);
                }
                if ((descriptionGroup2 = this.getDescriptionGroup((descriptionValue = annotation.value("description")) == null ? "" : descriptionValue.asString(), (displayNameValue = annotation.value("displayName")) == null ? "" : displayNameValue.asString(), (smallIconValue = annotation.value("smallIcon")) == null ? "" : smallIconValue.asString(), (largeIconValue2 = annotation.value("largeIcon")) == null ? "" : largeIconValue2.asString())) != null) {
                    servlet.setDescriptionGroup(descriptionGroup2);
                }
                ServletMappingMetaData servletMapping = new ServletMappingMetaData();
                servletMapping.setServletName(servlet.getName());
                urlPatterns = new ArrayList<String>();
                AnnotationValue urlPatternsValue = annotation.value("urlPatterns");
                if (urlPatternsValue != null) {
                    for (String urlPattern : urlPatternsValue.asStringArray()) {
                        urlPatterns.add(urlPattern);
                    }
                }
                if ((urlPatternsValue = annotation.value()) != null) {
                    for (String urlPattern : urlPatternsValue.asStringArray()) {
                        urlPatterns.add(urlPattern);
                    }
                }
                if (urlPatterns.size() > 0) {
                    servletMapping.setUrlPatterns(urlPatterns);
                    servletMappings.add(servletMapping);
                }
                servlets.add((MappableMetaData)servlet);
            }
        }
        if ((webFilterAnnotations = index.getAnnotations(WEB_FILTER)) != null && webFilterAnnotations.size() > 0) {
            ArrayList<FilterMappingMetaData> filterMappings;
            FiltersMetaData filters = metaData.getFilters();
            if (filters == null) {
                filters = new FiltersMetaData();
                metaData.setFilters(filters);
            }
            if ((filterMappings = metaData.getFilterMappings()) == null) {
                filterMappings = new ArrayList<FilterMappingMetaData>();
                metaData.setFilterMappings(filterMappings);
            }
            for (Object annotation : webFilterAnnotations) {
                AnnotationValue dispatcherTypesValue;
                AnnotationValue servletNamesValue;
                String urlPattern;
                int n;
                String[] descriptions;
                FilterMetaData filter = new FilterMetaData();
                target = annotation.target();
                classInfo = (ClassInfo)ClassInfo.class.cast(target);
                filter.setFilterClass(classInfo.toString());
                AnnotationValue nameValue = annotation.value("filterName");
                if (nameValue == null || nameValue.asString().isEmpty()) {
                    filter.setName(classInfo.toString());
                } else {
                    filter.setName(nameValue.asString());
                }
                asyncSupported = annotation.value("asyncSupported");
                if (asyncSupported != null) {
                    filter.setAsyncSupported(asyncSupported.asBoolean());
                }
                if ((initParamsValue = annotation.value("initParams")) != null && (initParamsAnnotations = initParamsValue.asNestedArray()) != null && initParamsAnnotations.length > 0) {
                    initParams = new ArrayList();
                    smallIconValue = initParamsAnnotations;
                    int largeIconValue2 = smallIconValue.length;
                    for (int descriptionGroup2 = 0; descriptionGroup2 < largeIconValue2; ++descriptionGroup2) {
                        AnnotationInstance initParamsAnnotation;
                        initParamsAnnotation = smallIconValue[descriptionGroup2];
                        initParam = new ParamValueMetaData();
                        initParamName = initParamsAnnotation.value("name");
                        initParamValue = initParamsAnnotation.value();
                        AnnotationValue initParamDescription = initParamsAnnotation.value("description");
                        initParam.setParamName(initParamName.asString());
                        initParam.setParamValue(initParamValue.asString());
                        if (initParamDescription != null && (descriptions = this.getDescription(initParamDescription.asString())) != null) {
                            initParam.setDescriptions((Descriptions)descriptions);
                        }
                        initParams.add(initParam);
                    }
                    filter.setInitParam(initParams);
                }
                if ((descriptionGroup2 = this.getDescriptionGroup((descriptionValue = annotation.value("description")) == null ? "" : descriptionValue.asString(), (displayNameValue = annotation.value("displayName")) == null ? "" : displayNameValue.asString(), (smallIconValue = annotation.value("smallIcon")) == null ? "" : smallIconValue.asString(), (largeIconValue2 = annotation.value("largeIcon")) == null ? "" : largeIconValue2.asString())) != null) {
                    filter.setDescriptionGroup(descriptionGroup2);
                }
                filters.add((MappableMetaData)filter);
                FilterMappingMetaData filterMapping = new FilterMappingMetaData();
                filterMapping.setFilterName(filter.getName());
                urlPatterns = new ArrayList();
                ArrayList<String> servletNames = new ArrayList<String>();
                ArrayList<DispatcherType> dispatchers = new ArrayList<DispatcherType>();
                AnnotationValue urlPatternsValue = annotation.value("urlPatterns");
                if (urlPatternsValue != null) {
                    descriptions = urlPatternsValue.asStringArray();
                    int urlPattern2 = descriptions.length;
                    for (n = 0; n < urlPattern2; ++n) {
                        urlPattern = descriptions[n];
                        urlPatterns.add(urlPattern);
                    }
                }
                if ((urlPatternsValue = annotation.value()) != null) {
                    descriptions = urlPatternsValue.asStringArray();
                    int urlPattern2 = descriptions.length;
                    for (n = 0; n < urlPattern2; ++n) {
                        urlPattern = descriptions[n];
                        urlPatterns.add(urlPattern);
                    }
                }
                if (urlPatterns.size() > 0) {
                    filterMapping.setUrlPatterns(urlPatterns);
                }
                if ((servletNamesValue = annotation.value("servletNames")) != null) {
                    String[] urlPattern2 = servletNamesValue.asStringArray();
                    n = urlPattern2.length;
                    for (int urlPattern3 = 0; urlPattern3 < n; ++urlPattern3) {
                        String servletName = urlPattern2[urlPattern3];
                        servletNames.add(servletName);
                    }
                }
                if (servletNames.size() > 0) {
                    filterMapping.setServletNames(servletNames);
                }
                if ((dispatcherTypesValue = annotation.value("dispatcherTypes")) != null) {
                    for (String dispatcherValue : dispatcherTypesValue.asEnumArray()) {
                        dispatchers.add(DispatcherType.valueOf((String)dispatcherValue));
                    }
                }
                if (dispatchers.size() > 0) {
                    filterMapping.setDispatchers(dispatchers);
                }
                if (urlPatterns.size() <= 0 && servletNames.size() <= 0) continue;
                filterMappings.add(filterMapping);
            }
        }
        if ((webListenerAnnotations = index.getAnnotations(WEB_LISTENER)) != null && webListenerAnnotations.size() > 0) {
            ArrayList<ListenerMetaData> listeners = metaData.getListeners();
            if (listeners == null) {
                listeners = new ArrayList<ListenerMetaData>();
                metaData.setListeners(listeners);
            }
            for (Object annotation : webListenerAnnotations) {
                DescriptionGroupMetaData descriptionGroup3;
                ListenerMetaData listener = new ListenerMetaData();
                target = annotation.target();
                classInfo = (ClassInfo)ClassInfo.class.cast(target);
                listener.setListenerClass(classInfo.toString());
                AnnotationValue descriptionValue2 = annotation.value();
                if (descriptionValue2 != null && (descriptionGroup3 = this.getDescriptionGroup(descriptionValue2.asString())) != null) {
                    listener.setDescriptionGroup(descriptionGroup3);
                }
                listeners.add(listener);
            }
        }
        if ((runAsAnnotations = index.getAnnotations(RUN_AS)) != null && runAsAnnotations.size() > 0) {
            AnnotationsMetaData annotations = metaData.getAnnotations();
            if (annotations == null) {
                annotations = new AnnotationsMetaData();
                metaData.setAnnotations(annotations);
            }
            for (AnnotationInstance annotation : runAsAnnotations) {
                target = annotation.target();
                if (!(target instanceof ClassInfo)) continue;
                classInfo = (ClassInfo)ClassInfo.class.cast(target);
                AnnotationMetaData annotationMD = (AnnotationMetaData)annotations.get(classInfo.toString());
                if (annotationMD == null) {
                    annotationMD = new AnnotationMetaData();
                    annotationMD.setClassName(classInfo.toString());
                    annotations.add((MappableMetaData)annotationMD);
                }
                RunAsMetaData runAs = new RunAsMetaData();
                runAs.setRoleName(annotation.value().asString());
                annotationMD.setRunAs(runAs);
            }
        }
        if ((declareRolesAnnotations = index.getAnnotations(DECLARE_ROLES)) != null && declareRolesAnnotations.size() > 0) {
            SecurityRolesMetaData securityRoles = metaData.getSecurityRoles();
            if (securityRoles == null) {
                securityRoles = new SecurityRolesMetaData();
                metaData.setSecurityRoles(securityRoles);
            }
            for (AnnotationInstance annotation : declareRolesAnnotations) {
                for (ClassInfo role : annotation.value().asStringArray()) {
                    SecurityRoleMetaData sr = new SecurityRoleMetaData();
                    sr.setRoleName((String)role);
                    securityRoles.add((MappableMetaData)sr);
                }
            }
        }
        if ((multipartConfigAnnotations = index.getAnnotations(MULTIPART_CONFIG)) != null && multipartConfigAnnotations.size() > 0) {
            AnnotationsMetaData annotations = metaData.getAnnotations();
            if (annotations == null) {
                annotations = new AnnotationsMetaData();
                metaData.setAnnotations(annotations);
            }
            for (AnnotationInstance annotation : multipartConfigAnnotations) {
                AnnotationValue fileSizeThresholdValue;
                AnnotationValue maxRequestSizeValue;
                AnnotationValue maxFileSizeValue;
                AnnotationTarget target3 = annotation.target();
                ClassInfo classInfo3 = (ClassInfo)ClassInfo.class.cast(target3);
                AnnotationMetaData annotationMD = (AnnotationMetaData)annotations.get(classInfo3.toString());
                if (annotationMD == null) {
                    annotationMD = new AnnotationMetaData();
                    annotationMD.setClassName(classInfo3.toString());
                    annotations.add((MappableMetaData)annotationMD);
                }
                MultipartConfigMetaData multipartConfig = new MultipartConfigMetaData();
                AnnotationValue locationValue = annotation.value("location");
                if (locationValue != null && locationValue.asString().length() > 0) {
                    multipartConfig.setLocation(locationValue.asString());
                }
                if ((maxFileSizeValue = annotation.value("maxFileSize")) != null && maxFileSizeValue.asLong() != -1L) {
                    multipartConfig.setMaxFileSize(maxFileSizeValue.asLong());
                }
                if ((maxRequestSizeValue = annotation.value("maxRequestSize")) != null && maxRequestSizeValue.asLong() != -1L) {
                    multipartConfig.setMaxRequestSize(maxRequestSizeValue.asLong());
                }
                if ((fileSizeThresholdValue = annotation.value("fileSizeThreshold")) != null && fileSizeThresholdValue.asInt() != 0) {
                    multipartConfig.setFileSizeThreshold(fileSizeThresholdValue.asInt());
                }
                annotationMD.setMultipartConfig(multipartConfig);
            }
        }
        if ((servletSecurityAnnotations = index.getAnnotations(SERVLET_SECURITY)) != null && servletSecurityAnnotations.size() > 0) {
            AnnotationsMetaData annotations = metaData.getAnnotations();
            if (annotations == null) {
                annotations = new AnnotationsMetaData();
                metaData.setAnnotations(annotations);
            }
            for (AnnotationInstance annotation : servletSecurityAnnotations) {
                AnnotationInstance[] httpMethodConstraints;
                AnnotationTarget target4 = annotation.target();
                ClassInfo classInfo4 = (ClassInfo)ClassInfo.class.cast(target4);
                AnnotationMetaData annotationMD = (AnnotationMetaData)annotations.get(classInfo4.toString());
                if (annotationMD == null) {
                    annotationMD = new AnnotationMetaData();
                    annotationMD.setClassName(classInfo4.toString());
                    annotations.add((MappableMetaData)annotationMD);
                }
                ServletSecurityMetaData servletSecurity = new ServletSecurityMetaData();
                AnnotationValue httpConstraintValue = annotation.value();
                ArrayList<String> rolesAllowed = new ArrayList<String>();
                if (httpConstraintValue != null) {
                    AnnotationValue rolesAllowedValue;
                    AnnotationValue httpConstraintTGValue;
                    AnnotationInstance httpConstraint = httpConstraintValue.asNested();
                    AnnotationValue httpConstraintERSValue = httpConstraint.value();
                    if (httpConstraintERSValue != null) {
                        servletSecurity.setEmptyRoleSemantic(EmptyRoleSemanticType.valueOf((String)httpConstraintERSValue.asEnum()));
                    }
                    if ((httpConstraintTGValue = httpConstraint.value("transportGuarantee")) != null) {
                        servletSecurity.setTransportGuarantee(org.jboss.metadata.web.spec.TransportGuaranteeType.valueOf((String)httpConstraintTGValue.asEnum()));
                    }
                    if ((rolesAllowedValue = httpConstraint.value("rolesAllowed")) != null) {
                        String[] stringArray = rolesAllowedValue.asStringArray();
                        int n = stringArray.length;
                        for (int servletNamesValue = 0; servletNamesValue < n; ++servletNamesValue) {
                            String role = stringArray[servletNamesValue];
                            rolesAllowed.add(role);
                        }
                    }
                }
                servletSecurity.setRolesAllowed(rolesAllowed);
                AnnotationValue httpMethodConstraintsValue = annotation.value("httpMethodConstraints");
                if (httpMethodConstraintsValue != null && (httpMethodConstraints = httpMethodConstraintsValue.asNestedArray()).length > 0) {
                    ArrayList<HttpMethodConstraintMetaData> methodConstraints = new ArrayList<HttpMethodConstraintMetaData>();
                    for (AnnotationInstance httpMethodConstraint : httpMethodConstraints) {
                        AnnotationValue httpMethodConstraintTGValue;
                        AnnotationValue httpMethodConstraintERSValue;
                        HttpMethodConstraintMetaData methodConstraint = new HttpMethodConstraintMetaData();
                        AnnotationValue httpMethodConstraintValue = httpMethodConstraint.value();
                        if (httpMethodConstraintValue != null) {
                            methodConstraint.setMethod(httpMethodConstraintValue.asString());
                        }
                        if ((httpMethodConstraintERSValue = httpMethodConstraint.value("emptyRoleSemantic")) != null) {
                            methodConstraint.setEmptyRoleSemantic(EmptyRoleSemanticType.valueOf((String)httpMethodConstraintERSValue.asEnum()));
                        }
                        if ((httpMethodConstraintTGValue = httpMethodConstraint.value("transportGuarantee")) != null) {
                            methodConstraint.setTransportGuarantee(org.jboss.metadata.web.spec.TransportGuaranteeType.valueOf((String)httpMethodConstraintTGValue.asEnum()));
                        }
                        AnnotationValue rolesAllowedValue = httpMethodConstraint.value("rolesAllowed");
                        rolesAllowed = new ArrayList();
                        if (rolesAllowedValue != null) {
                            for (String role : rolesAllowedValue.asStringArray()) {
                                rolesAllowed.add(role);
                            }
                        }
                        methodConstraint.setRolesAllowed(rolesAllowed);
                        methodConstraints.add(methodConstraint);
                    }
                    servletSecurity.setHttpMethodConstraints(methodConstraints);
                }
                annotationMD.setServletSecurity(servletSecurity);
            }
        }
    }

    private static TransportGuaranteeType transportGuaranteeType(org.jboss.metadata.web.spec.TransportGuaranteeType type) {
        if (type == null) {
            return TransportGuaranteeType.NONE;
        }
        switch (type) {
            case CONFIDENTIAL: {
                return TransportGuaranteeType.CONFIDENTIAL;
            }
            case INTEGRAL: {
                return TransportGuaranteeType.INTEGRAL;
            }
            case NONE: {
                return TransportGuaranteeType.NONE;
            }
        }
        throw new RuntimeException("UNREACHABLE");
    }

    protected Descriptions getDescription(String description) {
        DescriptionsImpl descriptions = null;
        if (description.length() > 0) {
            DescriptionImpl di = new DescriptionImpl();
            di.setDescription(description);
            descriptions = new DescriptionsImpl();
            descriptions.add((MappableMetaData)di);
        }
        return descriptions;
    }

    protected DisplayNames getDisplayName(String displayName) {
        DisplayNamesImpl displayNames = null;
        if (displayName.length() > 0) {
            DisplayNameImpl dn = new DisplayNameImpl();
            dn.setDisplayName(displayName);
            displayNames = new DisplayNamesImpl();
            displayNames.add((MappableMetaData)dn);
        }
        return displayNames;
    }

    protected Icons getIcons(String smallIcon, String largeIcon) {
        IconsImpl icons = null;
        if (smallIcon.length() > 0 || largeIcon.length() > 0) {
            IconImpl i = new IconImpl();
            i.setSmallIcon(smallIcon);
            i.setLargeIcon(largeIcon);
            icons = new IconsImpl();
            icons.add((MappableMetaData)i);
        }
        return icons;
    }

    protected DescriptionGroupMetaData getDescriptionGroup(String description) {
        DescriptionGroupMetaData dg = null;
        if (description.length() > 0) {
            dg = new DescriptionGroupMetaData();
            Descriptions descriptions = this.getDescription(description);
            dg.setDescriptions(descriptions);
        }
        return dg;
    }

    protected DescriptionGroupMetaData getDescriptionGroup(String description, String displayName, String smallIcon, String largeIcon) {
        DescriptionGroupMetaData dg = null;
        if (description.length() > 0 || displayName.length() > 0 || smallIcon.length() > 0 || largeIcon.length() > 0) {
            Icons icons;
            DisplayNames displayNames;
            dg = new DescriptionGroupMetaData();
            Descriptions descriptions = this.getDescription(description);
            if (descriptions != null) {
                dg.setDescriptions(descriptions);
            }
            if ((displayNames = this.getDisplayName(displayName)) != null) {
                dg.setDisplayNames(displayNames);
            }
            if ((icons = this.getIcons(smallIcon, largeIcon)) != null) {
                dg.setIcons(icons);
            }
        }
        return dg;
    }
}

