/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationSourceBuildItem;
import io.quarkus.deployment.builditem.SslNativeConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import io.quarkus.vault.VaultKVSecretEngine;
import io.quarkus.vault.runtime.Base64StringDeserializer;
import io.quarkus.vault.runtime.Base64StringSerializer;
import io.quarkus.vault.runtime.VaultRecorder;
import io.quarkus.vault.runtime.VaultServiceProducer;
import io.quarkus.vault.runtime.client.dto.VaultModel;
import io.quarkus.vault.runtime.config.VaultBuildTimeConfig;
import io.quarkus.vault.runtime.config.VaultConfigSource;
import io.quarkus.vault.runtime.config.VaultRuntimeConfig;
import java.util.OptionalInt;
import org.jboss.jandex.DotName;

public class VaultProcessor {
    @BuildStep
    void build(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<FeatureBuildItem> feature, CombinedIndexBuildItem combinedIndexBuildItem, SslNativeConfigBuildItem sslNativeConfig, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.VAULT));
        String[] modelClasses = (String[])combinedIndexBuildItem.getIndex().getAllKnownImplementors(DotName.createSimple((String)VaultModel.class.getName())).stream().map(c -> c.name().toString()).toArray(String[]::new);
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.weakClass((String[])modelClasses));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{Base64StringDeserializer.class, Base64StringSerializer.class}));
        sslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(Feature.VAULT));
    }

    @BuildStep
    void setUpConfigFile(BuildProducer<RunTimeConfigurationSourceBuildItem> configSourceConsumer) {
        configSourceConsumer.produce((BuildItem)new RunTimeConfigurationSourceBuildItem(VaultConfigSource.class.getName(), OptionalInt.of(150)));
    }

    @BuildStep
    AdditionalBeanBuildItem registerAdditionalBeans() {
        return new AdditionalBeanBuildItem.Builder().setUnremovable().addBeanClass(VaultServiceProducer.class).addBeanClass(VaultKVSecretEngine.class).build();
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void configure(VaultRecorder recorder, VaultBuildTimeConfig buildTimeConfig, VaultRuntimeConfig serverConfig) {
        recorder.configureRuntimeProperties(buildTimeConfig, serverConfig);
    }

    @BuildStep
    HealthBuildItem addHealthCheck(VaultBuildTimeConfig config) {
        return new HealthBuildItem("io.quarkus.vault.runtime.health.VaultHealthCheck", config.health.enabled);
    }
}

