/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.deployment;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDockerWorking;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.builditem.DevServicesNativeConfigResultBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.vault.runtime.config.DevServicesConfig;
import io.quarkus.vault.runtime.config.VaultBuildTimeConfig;
import java.io.Closeable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import org.apache.commons.lang3.RandomStringUtils;
import org.jboss.logging.Logger;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.vault.VaultContainer;

public class DevServicesVaultProcessor {
    private static final Logger log = Logger.getLogger(DevServicesVaultProcessor.class);
    private static final String VAULT_IMAGE = "vault:1.7.1";
    private static final int VAULT_EXPOSED_PORT = 8200;
    private static final String CONFIG_PREFIX = "quarkus.vault.";
    private static final String URL_CONFIG_KEY = "quarkus.vault.url";
    private static final String AUTH_CONFIG_PREFIX = "quarkus.vault.authentication.";
    private static final String CLIENT_TOKEN_CONFIG_KEY = "quarkus.vault.authentication.client-token";
    private static volatile List<Closeable> closeables;
    private static volatile DevServicesConfig capturedDevServicesConfiguration;
    private static volatile boolean first;
    private final IsDockerWorking isDockerWorking = new IsDockerWorking(true);

    @Produce(value=ServiceStartBuildItem.class)
    @BuildStep(onlyIfNot={IsNormal.class})
    public void startVaultContainers(LaunchModeBuildItem launchMode, BuildProducer<RunTimeConfigurationDefaultBuildItem> runTimeConfiguration, BuildProducer<DevServicesNativeConfigResultBuildItem> devConfig, VaultBuildTimeConfig config) {
        DevServicesConfig currentDevServicesConfiguration = config.devservices;
        if (closeables != null) {
            boolean restartRequired;
            boolean bl = restartRequired = launchMode.getLaunchMode() == LaunchMode.TEST;
            if (!restartRequired) {
                boolean bl2 = restartRequired = !currentDevServicesConfiguration.equals((Object)capturedDevServicesConfiguration);
            }
            if (!restartRequired) {
                return;
            }
            for (Closeable closeable : closeables) {
                try {
                    closeable.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Failed to stop Vault container", e);
                }
            }
            closeables = null;
            capturedDevServicesConfiguration = null;
        }
        capturedDevServicesConfiguration = currentDevServicesConfiguration;
        StartResult startResult = this.startContainer(currentDevServicesConfiguration);
        if (startResult == null) {
            return;
        }
        runTimeConfiguration.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem(URL_CONFIG_KEY, startResult.url));
        runTimeConfiguration.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem(CLIENT_TOKEN_CONFIG_KEY, startResult.clientToken));
        HashMap<String, String> connectionProperties = new HashMap<String, String>();
        connectionProperties.put(URL_CONFIG_KEY, startResult.url);
        connectionProperties.put(CLIENT_TOKEN_CONFIG_KEY, startResult.clientToken);
        closeables = Collections.singletonList(startResult.closeable);
        if (first) {
            first = false;
            Runnable closeTask = new Runnable(){

                @Override
                public void run() {
                    if (closeables != null) {
                        for (Closeable closeable : closeables) {
                            try {
                                closeable.close();
                            }
                            catch (Throwable t) {
                                log.error((Object)"Failed to stop Vault container", t);
                            }
                        }
                    }
                    first = true;
                    closeables = null;
                    capturedDevServicesConfiguration = null;
                }
            };
            QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
            ((QuarkusClassLoader)cl.parent()).addCloseTask(closeTask);
            final Thread closeHookThread = new Thread(closeTask, "Vault container shutdown thread");
            Runtime.getRuntime().addShutdownHook(closeHookThread);
            ((QuarkusClassLoader)cl.parent()).addCloseTask(new Runnable(){

                @Override
                public void run() {
                    Runtime.getRuntime().removeShutdownHook(closeHookThread);
                }
            });
        }
        for (Map.Entry entry : connectionProperties.entrySet()) {
            devConfig.produce((BuildItem)new DevServicesNativeConfigResultBuildItem((String)entry.getKey(), (String)entry.getValue()));
        }
    }

    private StartResult startContainer(DevServicesConfig devServicesConfig) {
        boolean needToStart;
        if (!devServicesConfig.enabled) {
            log.debug((Object)"Not starting devservices for Vault as it has been disabled in the config");
            return null;
        }
        if (!this.isDockerWorking.getAsBoolean()) {
            log.warn((Object)"Please configure Vault URL or get a working docker instance");
            return null;
        }
        boolean bl = needToStart = !ConfigUtils.isPropertyPresent((String)URL_CONFIG_KEY);
        if (!needToStart) {
            log.debug((Object)"Not starting devservices for default Vault client as url have been provided");
            return null;
        }
        String token = RandomStringUtils.randomAlphanumeric((int)10);
        DockerImageName dockerImageName = DockerImageName.parse((String)devServicesConfig.imageName.orElse(VAULT_IMAGE)).asCompatibleSubstituteFor(VAULT_IMAGE);
        final FixedPortVaultContainer vaultContainer = (FixedPortVaultContainer)new FixedPortVaultContainer(dockerImageName, devServicesConfig.port).withVaultToken(token);
        if (devServicesConfig.transitEnabled) {
            vaultContainer.withInitCommand(new String[]{"secrets enable transit"});
        }
        if (devServicesConfig.pkiEnabled) {
            vaultContainer.withInitCommand(new String[]{"secrets enable pki"});
        }
        vaultContainer.start();
        String url = "http://" + vaultContainer.getHost() + ":" + vaultContainer.getPort();
        return new StartResult(url, token, new Closeable(){

            @Override
            public void close() {
                vaultContainer.close();
            }
        });
    }

    static {
        first = true;
    }

    private static class FixedPortVaultContainer
    extends VaultContainer<FixedPortVaultContainer> {
        OptionalInt fixedExposedPort;

        public FixedPortVaultContainer(DockerImageName dockerImageName, OptionalInt fixedExposedPort) {
            super(dockerImageName);
            this.fixedExposedPort = fixedExposedPort;
        }

        protected void configure() {
            super.configure();
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 8200);
            } else {
                this.addExposedPort(8200);
            }
        }

        public int getPort() {
            if (this.fixedExposedPort.isPresent()) {
                return this.fixedExposedPort.getAsInt();
            }
            return super.getMappedPort(8200);
        }
    }

    private static class StartResult {
        private final String url;
        private final String clientToken;
        private final Closeable closeable;

        public StartResult(String url, String clientToken, Closeable closeable) {
            this.url = url;
            this.clientToken = clientToken;
            this.closeable = closeable;
        }
    }
}

