/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.logstream;

import io.quarkus.vertx.http.runtime.logstream.JsonFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;

public class HistoryHandler
extends ExtHandler {
    private final LinkedBlockingQueue<ExtLogRecord> history;

    public HistoryHandler() {
        this(50);
    }

    public HistoryHandler(int size) {
        this.history = new LinkedBlockingQueue(size);
        this.setLevel(Level.INFO);
        this.setFormatter((Formatter)((Object)new JsonFormatter()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doPublish(ExtLogRecord record) {
        if (record.getMessage() == null || record.getMessage().isEmpty()) {
            return;
        }
        if (this.isLoggable((LogRecord)record)) {
            HistoryHandler historyHandler = this;
            synchronized (historyHandler) {
                try {
                    if (this.history.remainingCapacity() == 0) {
                        this.history.take();
                    }
                    this.history.add(record);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public boolean hasHistory() {
        return !this.history.isEmpty();
    }

    public List<ExtLogRecord> getHistory() {
        return new ArrayList<ExtLogRecord>(this.history);
    }

    public void clearHistory() {
        this.history.clear();
    }
}

