/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.jsonrpc;

import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import java.util.Map;

public class JsonRpcReader {
    private final JsonObject jsonObject;

    private JsonRpcReader(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public static JsonRpcReader read(String json) {
        return new JsonRpcReader((JsonObject)Json.decodeValue((String)json));
    }

    public int getId() {
        return this.jsonObject.getInteger("id");
    }

    public String getJsonrpc() {
        return this.jsonObject.getString("jsonrpc", "2.0");
    }

    public String getMethod() {
        return this.jsonObject.getString("method");
    }

    public boolean isMethod(String m) {
        return this.getMethod().equalsIgnoreCase(m);
    }

    public boolean hasParams() {
        return this.getParams() != null;
    }

    public Map<String, ?> getParams() {
        JsonObject paramsObject = this.jsonObject.getJsonObject("params");
        if (paramsObject != null && paramsObject.getMap() != null && !paramsObject.getMap().isEmpty()) {
            return paramsObject.getMap();
        }
        return null;
    }

    public <T> T getParam(String key) {
        Map<String, ?> params = this.getParams();
        if (params == null || !params.containsKey(key)) {
            return null;
        }
        return (T)params.get(key);
    }

    public String toString() {
        return this.jsonObject.encodePrettily();
    }
}

