/*
 * Decompiled with CFR 0.152.
 */
package io.radanalytics.operator;

import com.jcabi.manifests.Manifests;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.prometheus.client.exporter.HTTPServer;
import io.prometheus.client.hotspot.DefaultExports;
import io.radanalytics.operator.common.AbstractOperator;
import io.radanalytics.operator.common.AnsiColors;
import io.radanalytics.operator.common.OperatorConfig;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Entrypoint {
    private static final Logger log = LoggerFactory.getLogger((String)Entrypoint.class.getName());
    public static ExecutorService EXECUTORS = Executors.newFixedThreadPool(10);

    public static void main(String[] args) {
        log.info("Starting..");
        OperatorConfig config = OperatorConfig.fromMap(System.getenv());
        DefaultKubernetesClient client = new DefaultKubernetesClient();
        boolean isOpenshift = Entrypoint.isOnOpenShift((KubernetesClient)client);
        CompletionStage future = Entrypoint.run((KubernetesClient)client, isOpenshift, config).exceptionally(ex -> {
            log.error("Unable to start operator for one or more namespaces", ex);
            System.exit(1);
            return null;
        });
        if (config.isMetrics()) {
            CompletionStage completionStage = ((CompletableFuture)future).thenCompose(s -> Entrypoint.runMetrics(isOpenshift, config));
        }
    }

    private static CompletableFuture<Void> run(KubernetesClient client, boolean isOpenShift, OperatorConfig config) {
        Entrypoint.printInfo();
        if (isOpenShift) {
            log.info("{}OpenShift{} environment detected.", (Object)AnsiColors.ye(), (Object)AnsiColors.xx());
        } else {
            log.info("{}Kubernetes{} environment detected.", (Object)AnsiColors.ye(), (Object)AnsiColors.xx());
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        if (null == config.getNamespaces()) {
            String namespace = client.getNamespace();
            CompletableFuture<Void> future = Entrypoint.runForNamespace(client, isOpenShift, namespace, config.getReconciliationIntervalS(), 0);
            futures.add(future);
        } else {
            Iterator<String> ns = config.getNamespaces().iterator();
            for (int i = 0; i < config.getNamespaces().size(); ++i) {
                CompletableFuture<Void> future = Entrypoint.runForNamespace(client, isOpenShift, ns.next(), config.getReconciliationIntervalS(), i);
                futures.add(future);
            }
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private static CompletableFuture<Optional<HTTPServer>> runMetrics(boolean isOpenShift, OperatorConfig config) {
        HTTPServer httpServer = null;
        try {
            log.info("Starting a simple HTTP server for exposing internal metrics..");
            httpServer = new HTTPServer(config.getMetricsPort());
            log.info("{}metrics server{} listens on port {}", new Object[]{AnsiColors.ye(), AnsiColors.xx(), config.getMetricsPort()});
        }
        catch (IOException e) {
            log.error("Can't start metrics server because of: {} ", (Object)e.getMessage());
            e.printStackTrace();
        }
        if (config.isMetricsJvm()) {
            DefaultExports.initialize();
        }
        Optional<HTTPServer> maybeServer = Optional.of(httpServer);
        return CompletableFuture.supplyAsync(() -> maybeServer);
    }

    private static CompletableFuture<Void> runForNamespace(KubernetesClient client, boolean isOpenShift, String namespace, long reconInterval, int delay) {
        LinkedList<ClassLoader> classLoadersList = new LinkedList<ClassLoader>();
        classLoadersList.add(ClasspathHelper.contextClassLoader());
        classLoadersList.add(ClasspathHelper.staticClassLoader());
        ArrayList operatorClasses = new ArrayList();
        try {
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new TypeAnnotationsScanner(), new SubTypesScanner(false), new ResourcesScanner()}).setUrls(ClasspathHelper.forClassLoader((ClassLoader[])classLoadersList.toArray(new ClassLoader[0]))));
            operatorClasses.addAll(reflections.getSubTypesOf(AbstractOperator.class));
        }
        catch (ReflectionsException re) {
            log.debug(re.getMessage());
        }
        ArrayList futures = new ArrayList();
        int operatorNumber = operatorClasses.size();
        IntStream.range(0, operatorNumber).forEach(operatorIndex -> {
            Class operatorClass = (Class)operatorClasses.get(operatorIndex);
            try {
                AbstractOperator operator;
                if (!AbstractOperator.class.isAssignableFrom(operatorClass)) {
                    log.error("Class {} annotated with @Operator doesn't extend the AbstractOperator", (Object)operatorClass);
                    System.exit(1);
                }
                if (!(operator = (AbstractOperator)operatorClass.newInstance()).isEnabled()) {
                    log.info("Skipping initialization of {} operator", (Object)operatorClass);
                    return;
                }
                operator.setClient(client);
                operator.setNamespace(namespace);
                operator.setOpenshift(isOpenShift);
                CompletionStage future = ((CompletableFuture)operator.start().thenApply(res -> {
                    log.info("{} started in namespace {}", (Object)operator.getName(), (Object)namespace);
                    return res;
                })).exceptionally(ex -> {
                    log.error("{} in namespace {} failed to start", new Object[]{operator.getName(), namespace, ((Throwable)ex).getCause()});
                    System.exit(1);
                    return null;
                });
                ScheduledExecutorService s = Executors.newScheduledThreadPool(1);
                int realDelay = delay * operatorNumber + operatorIndex + 2;
                ScheduledFuture<?> scheduledFuture = s.scheduleAtFixedRate(() -> {
                    try {
                        operator.fullReconciliation();
                        operator.setFullReconciliationRun(true);
                    }
                    catch (Throwable t) {
                        log.warn("error during full reconciliation: {}", (Object)t.getMessage());
                        t.printStackTrace();
                    }
                }, realDelay, reconInterval, TimeUnit.SECONDS);
                log.info("full reconciliation for {} scheduled (periodically each {} seconds)", (Object)operator.getName(), (Object)reconInterval);
                log.info("the first full reconciliation for {} is happening in {} seconds", (Object)operator.getName(), (Object)realDelay);
                futures.add(future);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        });
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private static boolean isOnOpenShift(KubernetesClient client) {
        Response response;
        URL kubernetesApi = client.getMasterUrl();
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder();
        urlBuilder.host(kubernetesApi.getHost());
        if (kubernetesApi.getPort() == -1) {
            urlBuilder.port(kubernetesApi.getDefaultPort());
        } else {
            urlBuilder.port(kubernetesApi.getPort());
        }
        if (kubernetesApi.getProtocol().equals("https")) {
            urlBuilder.scheme("https");
        }
        urlBuilder.addPathSegment("oapi");
        OkHttpClient httpClient = HttpClientUtils.createHttpClient((Config)new ConfigBuilder().build());
        HttpUrl url = urlBuilder.build();
        try {
            response = httpClient.newCall(new Request.Builder().url(url).build()).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("Failed to distinguish between Kubernetes and OpenShift");
            log.warn("Let's assume we are on K8s");
            return false;
        }
        boolean success = response.isSuccessful();
        if (success) {
            log.info("{} returned {}. We are on OpenShift.", (Object)url, (Object)response.code());
        } else {
            log.info("{} returned {}. We are not on OpenShift. Assuming, we are on Kubernetes.", (Object)url, (Object)response.code());
        }
        return success;
    }

    private static void printInfo() {
        String gitSha = "unknown";
        String version = "unknown";
        try {
            version = Entrypoint.class.getPackage().getImplementationVersion();
            gitSha = Manifests.read((String)"Implementation-Build");
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.info("\n{}Operator{} has started in version {}{}{}. {}\n", new Object[]{AnsiColors.re(), AnsiColors.xx(), AnsiColors.gr(), version, AnsiColors.xx(), AnsiColors.FOO});
        if (!gitSha.isEmpty()) {
            log.info("Git sha: {}{}{}", new Object[]{AnsiColors.ye(), gitSha, AnsiColors.xx()});
        }
        log.info("==================\n");
    }
}

