/*
 * Decompiled with CFR 0.152.
 */
package io.radanalytics.operator.common;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionList;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionSpecFluent;
import io.fabric8.kubernetes.api.model.apiextensions.JSONSchemaProps;
import io.fabric8.kubernetes.client.CustomResourceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import io.radanalytics.operator.common.AbstractWatcher;
import io.radanalytics.operator.common.AnsiColors;
import io.radanalytics.operator.common.ConfigMapWatcher;
import io.radanalytics.operator.common.CustomResourceWatcher;
import io.radanalytics.operator.common.EntityInfo;
import io.radanalytics.operator.common.JSONSchemaReader;
import io.radanalytics.operator.common.Operator;
import io.radanalytics.operator.common.crd.InfoClass;
import io.radanalytics.operator.common.crd.InfoClassDoneable;
import io.radanalytics.operator.common.crd.InfoList;
import io.radanalytics.operator.resource.LabelsHelper;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperator<T extends EntityInfo> {
    protected static final Logger log = LoggerFactory.getLogger((String)AbstractOperator.class.getName());
    protected KubernetesClient client;
    protected boolean isOpenshift;
    protected String namespace;
    protected String entityName;
    protected String prefix;
    protected Class<T> infoClass;
    protected boolean isCrd;
    protected boolean enabled = true;
    protected String named;
    protected volatile boolean fullReconciliationRun = false;
    private Map<String, String> selector;
    private String operatorName;
    private CustomResourceDefinition crd;
    private volatile AbstractWatcher watch;

    public AbstractOperator() {
        Operator annotation = this.getClass().getAnnotation(Operator.class);
        if (annotation != null) {
            this.infoClass = annotation.forKind();
            this.named = annotation.named();
            this.isCrd = annotation.crd();
            this.enabled = annotation.enabled();
            this.prefix = annotation.prefix();
        } else {
            log.info("Annotation on the operator class not found, falling back to direct field access.");
            log.info("If the initialization fails, it's probably due to the fact that some compulsory fields are missing.");
            log.info("Compulsory fields: infoClass");
        }
    }

    protected abstract void onAdd(T var1);

    protected void onAdd(T entity, String namespace) {
        this.onAction(entity, namespace, this::onAdd);
    }

    protected abstract void onDelete(T var1);

    protected void onDelete(T entity, String namespace) {
        this.onAction(entity, namespace, this::onDelete);
    }

    protected void onModify(T entity) {
        this.onDelete(entity);
        this.onAdd(entity);
    }

    protected void onModify(T entity, String namespace) {
        this.onAction(entity, namespace, this::onModify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAction(T entity, String namespace, Consumer<T> handler) {
        if ("*".equals(this.namespace)) {
            try {
                this.namespace = namespace;
                handler.accept(entity);
            }
            finally {
                this.namespace = "*";
            }
        } else {
            handler.accept(entity);
        }
    }

    protected void onInit() {
    }

    public void fullReconciliation() {
    }

    protected boolean isSupported(ConfigMap cm) {
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected T convert(ConfigMap cm) {
        return ConfigMapWatcher.defaultConvert(this.infoClass, cm);
    }

    protected T convertCr(InfoClass info) {
        return CustomResourceWatcher.defaultConvert(this.infoClass, info);
    }

    public String getName() {
        return this.operatorName;
    }

    public CompletableFuture<? extends AbstractWatcher> start() {
        this.initInternals();
        this.selector = LabelsHelper.forKind(this.entityName, this.prefix);
        boolean ok = this.checkIntegrity();
        if (!ok) {
            log.warn("Unable to initialize the operator correctly, some compulsory fields are missing.");
            return CompletableFuture.completedFuture(null);
        }
        log.info("Starting {} for namespace {}", (Object)this.operatorName, (Object)this.namespace);
        if (this.isCrd) {
            this.crd = this.initCrds();
        }
        this.onInit();
        CompletableFuture<AbstractWatcher<T>> future = this.initializeWatcher();
        ((CompletableFuture)future.thenApply(res -> {
            this.watch = res;
            log.info("{}{} running{} for namespace {}", new Object[]{AnsiColors.gr(), this.operatorName, AnsiColors.xx(), this.namespace});
            return res;
        })).exceptionally(e -> {
            log.error("{} startup failed for namespace {}", new Object[]{this.operatorName, this.namespace, e.getCause()});
            return null;
        });
        return future;
    }

    private CompletableFuture<? extends AbstractWatcher<T>> initializeWatcher() {
        CompletableFuture<AbstractWatcher> future;
        if (this.isCrd) {
            CustomResourceWatcher.Builder crBuilder = new CustomResourceWatcher.Builder();
            CustomResourceWatcher crWatcher = crBuilder.withClient(this.client).withCrd(this.crd).withEntityName(this.entityName).withNamespace(this.namespace).withConvert(this::convertCr).withOnAdd(this::onAdd).withOnDelete(this::onDelete).withOnModify(this::onModify).build();
            future = crWatcher.watch();
        } else {
            ConfigMapWatcher.Builder cmBuilder = new ConfigMapWatcher.Builder();
            ConfigMapWatcher cmWatcher = cmBuilder.withClient(this.client).withSelector(this.selector).withEntityName(this.entityName).withNamespace(this.namespace).withConvert(this::convert).withOnAdd(this::onAdd).withOnDelete(this::onDelete).withOnModify(this::onModify).withPredicate(this::isSupported).build();
            future = cmWatcher.watch();
        }
        return future;
    }

    private boolean checkIntegrity() {
        boolean ok = this.infoClass != null;
        ok = ok && this.entityName != null && !this.entityName.isEmpty();
        ok = ok && this.prefix != null && !this.prefix.isEmpty() && this.prefix.endsWith("/");
        ok = ok && this.operatorName != null && this.operatorName.endsWith("operator");
        return ok;
    }

    private void initInternals() {
        this.entityName = this.named != null && !this.named.isEmpty() ? this.named.toLowerCase() : (this.entityName != null && !this.entityName.isEmpty() ? this.entityName.toLowerCase() : (this.infoClass == null ? "" : this.infoClass.getSimpleName().toLowerCase()));
        this.isCrd = this.isCrd || "true".equals(System.getenv("CRD"));
        this.prefix = this.prefix == null || this.prefix.isEmpty() ? this.getClass().getPackage().getName() : this.prefix;
        this.prefix = this.prefix + (!this.prefix.endsWith("/") ? "/" : "");
        this.operatorName = "'" + this.entityName + "' operator";
    }

    private CustomResourceDefinition initCrds() {
        CustomResourceDefinition crdToReturn;
        String newPrefix = this.prefix.substring(0, this.prefix.length() - 1);
        List crds = ((CustomResourceDefinitionList)this.client.customResourceDefinitions().list()).getItems().stream().filter(p -> this.entityName.equals(p.getSpec().getNames().getKind())).collect(Collectors.toList());
        if (!crds.isEmpty()) {
            crdToReturn = (CustomResourceDefinition)crds.get(0);
        } else {
            String plural = this.entityName + "s";
            JSONSchemaProps schema = JSONSchemaReader.readSchema(this.infoClass);
            CustomResourceDefinitionFluent.SpecNested builder = (CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.MetadataNested)((CustomResourceDefinitionBuilder)new CustomResourceDefinitionBuilder().withApiVersion("apiextensions.k8s.io/v1beta1")).withNewMetadata().withName(plural + "." + newPrefix)).endMetadata()).withNewSpec().withNewNames().withKind(this.entityName)).withPlural(plural)).endNames()).withGroup(newPrefix)).withVersion("v1")).withScope("Namespaced");
            if (schema != null) {
                builder = (CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.ValidationNested)builder.withNewValidation().withNewOpenAPIV3SchemaLike(schema).endOpenAPIV3Schema()).endValidation();
            }
            crdToReturn = ((CustomResourceDefinitionBuilder)builder.endSpec()).build();
            this.client.customResourceDefinitions().createOrReplace((Object[])new CustomResourceDefinition[]{crdToReturn});
        }
        KubernetesDeserializer.registerCustomKind((String)(newPrefix + "/" + crdToReturn.getSpec().getVersion() + "#" + this.entityName), InfoClass.class);
        KubernetesDeserializer.registerCustomKind((String)(newPrefix + "/" + crdToReturn.getSpec().getVersion() + "#" + this.entityName + "List"), CustomResourceList.class);
        return crdToReturn;
    }

    public void stop() {
        log.info("Stopping {} for namespace {}", (Object)this.operatorName, (Object)this.namespace);
        this.watch.close();
        this.client.close();
    }

    protected Set<T> getDesiredSet() {
        Set desiredSet;
        if (this.isCrd) {
            MixedOperation aux1 = this.client.customResources(this.crd, InfoClass.class, InfoList.class, InfoClassDoneable.class);
            FilterWatchListMultiDeletable aux2 = "*".equals(this.namespace) ? (FilterWatchListMultiDeletable)aux1.inAnyNamespace() : (FilterWatchListMultiDeletable)aux1.inNamespace(this.namespace);
            CustomResourceList listAux = (CustomResourceList)aux2.list();
            List items = listAux.getItems();
            desiredSet = items.stream().flatMap(item -> {
                try {
                    return Stream.of(this.convertCr((InfoClass)((Object)item)));
                }
                catch (Exception e) {
                    return Stream.empty();
                }
            }).collect(Collectors.toSet());
        } else {
            MixedOperation aux1 = this.client.configMaps();
            FilterWatchListMultiDeletable aux2 = "*".equals(this.namespace) ? (FilterWatchListMultiDeletable)aux1.inAnyNamespace() : (FilterWatchListMultiDeletable)aux1.inNamespace(this.namespace);
            desiredSet = ((ConfigMapList)((FilterWatchListDeletable)aux2.withLabels(this.selector)).list()).getItems().stream().flatMap(item -> {
                try {
                    return Stream.of(this.convert((ConfigMap)item));
                }
                catch (Exception e) {
                    return Stream.empty();
                }
            }).collect(Collectors.toSet());
        }
        return desiredSet;
    }

    public void setClient(KubernetesClient client) {
        this.client = client;
    }

    public void setOpenshift(boolean openshift) {
        this.isOpenshift = openshift;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setInfoClass(Class<T> infoClass) {
        this.infoClass = infoClass;
    }

    public void setCrd(boolean crd) {
        this.isCrd = crd;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setNamed(String named) {
        this.named = named;
    }

    public void setFullReconciliationRun(boolean fullReconciliationRun) {
        this.fullReconciliationRun = fullReconciliationRun;
        this.watch.setFullReconciliationRun(true);
    }
}

