/*
 * Decompiled with CFR 0.152.
 */
package io.radanalytics.operator.common;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Watchable;
import io.radanalytics.operator.Entrypoint;
import io.radanalytics.operator.common.AnsiColors;
import io.radanalytics.operator.common.EntityInfo;
import io.radanalytics.operator.common.crd.InfoClass;
import io.radanalytics.operator.common.crd.InfoClassDoneable;
import io.radanalytics.operator.common.crd.InfoList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWatcher<T extends EntityInfo> {
    protected static final Logger log = LoggerFactory.getLogger((String)AbstractWatcher.class.getName());
    private final boolean isCrd;
    private final String namespace;
    private final String entityName;
    private final KubernetesClient client;
    private final CustomResourceDefinition crd;
    private final Map<String, String> selector;
    private final BiConsumer<T, String> onAdd;
    private final BiConsumer<T, String> onDelete;
    private final BiConsumer<T, String> onModify;
    private final Predicate<ConfigMap> isSupported;
    private final Function<ConfigMap, T> convert;
    private final Function<InfoClass, T> convertCr;
    private volatile Watch watch;
    protected volatile boolean fullReconciliationRun = false;

    protected AbstractWatcher(boolean isCrd, String namespace, String entityName, KubernetesClient client, CustomResourceDefinition crd, Map<String, String> selector, BiConsumer<T, String> onAdd, BiConsumer<T, String> onDelete, BiConsumer<T, String> onModify, Predicate<ConfigMap> isSupported, Function<ConfigMap, T> convert, Function<InfoClass, T> convertCr) {
        this.isCrd = isCrd;
        this.namespace = namespace;
        this.entityName = entityName;
        this.client = client;
        this.crd = crd;
        this.selector = selector;
        this.onAdd = onAdd;
        this.onDelete = onDelete;
        this.onModify = onModify;
        this.isSupported = isSupported;
        this.convert = convert;
        this.convertCr = convertCr;
    }

    public abstract CompletableFuture<? extends AbstractWatcher<T>> watch();

    protected CompletableFuture<Watch> createConfigMapWatch() {
        CompletableFuture<Watch> cf = CompletableFuture.supplyAsync(() -> {
            MixedOperation aux = this.client.configMaps();
            final boolean inAllNs = "*".equals(this.namespace);
            Watchable watchable = inAllNs ? (Watchable)((FilterWatchListMultiDeletable)aux.inAnyNamespace()).withLabels(this.selector) : (Watchable)((NonNamespaceOperation)aux.inNamespace(this.namespace)).withLabels(this.selector);
            Watch watch = (Watch)watchable.watch((Object)new Watcher<ConfigMap>(){

                public void eventReceived(Watcher.Action action, ConfigMap cm) {
                    if (AbstractWatcher.this.isSupported.test(cm)) {
                        log.info("ConfigMap in namespace {} was {}\nCM:\n{}\n", new Object[]{AbstractWatcher.this.namespace, action, cm});
                        EntityInfo entity = (EntityInfo)AbstractWatcher.this.convert.apply(cm);
                        if (entity == null) {
                            log.error("something went wrong, unable to parse {} definition", (Object)AbstractWatcher.this.entityName);
                        }
                        if (action.equals((Object)Watcher.Action.ERROR)) {
                            log.error("Failed ConfigMap {} in namespace{} ", (Object)cm, (Object)AbstractWatcher.this.namespace);
                        } else {
                            AbstractWatcher.this.handleAction(action, entity, inAllNs ? cm.getMetadata().getNamespace() : AbstractWatcher.this.namespace);
                        }
                    } else {
                        log.error("Unknown CM kind: {}", (Object)cm.toString());
                    }
                }

                public void onClose(KubernetesClientException e) {
                    if (e != null) {
                        log.error("Watcher closed with exception in namespace {}", (Object)AbstractWatcher.this.namespace, (Object)e);
                        AbstractWatcher.this.recreateWatcher();
                    } else {
                        log.info("Watcher closed in namespace {}", (Object)AbstractWatcher.this.namespace);
                    }
                }
            });
            return watch;
        }, Entrypoint.EXECUTORS);
        ((CompletableFuture)cf.thenApply(w -> {
            log.info("ConfigMap watcher running for labels {}", this.selector);
            return w;
        })).exceptionally(e -> {
            log.error("ConfigMap watcher failed to start", e.getCause());
            return null;
        });
        return cf;
    }

    protected CompletableFuture<Watch> createCustomResourceWatch() {
        CompletableFuture<Watch> cf = CompletableFuture.supplyAsync(() -> {
            Watch watch;
            MixedOperation aux = this.client.customResources(this.crd, InfoClass.class, InfoList.class, InfoClassDoneable.class);
            final boolean inAllNs = "*".equals(this.namespace);
            Watchable watchable = inAllNs ? (Watchable)aux.inAnyNamespace() : (Watchable)aux.inNamespace(this.namespace);
            this.watch = watch = (Watch)watchable.watch((Object)new Watcher<InfoClass>(){

                public void eventReceived(Watcher.Action action, InfoClass info) {
                    log.info("Custom resource in namespace {} was {}\nCR:\n", new Object[]{AbstractWatcher.this.namespace, action, info});
                    EntityInfo entity = (EntityInfo)AbstractWatcher.this.convertCr.apply(info);
                    if (entity == null) {
                        log.error("something went wrong, unable to parse {} definition", (Object)AbstractWatcher.this.entityName);
                    }
                    if (action.equals((Object)Watcher.Action.ERROR)) {
                        log.error("Failed Custom resource {} in namespace{} ", (Object)info, (Object)AbstractWatcher.this.namespace);
                    } else {
                        AbstractWatcher.this.handleAction(action, entity, inAllNs ? info.getMetadata().getNamespace() : AbstractWatcher.this.namespace);
                    }
                }

                public void onClose(KubernetesClientException e) {
                    if (e != null) {
                        log.error("Watcher closed with exception in namespace {}", (Object)AbstractWatcher.this.namespace, (Object)e);
                        AbstractWatcher.this.recreateWatcher();
                    } else {
                        log.info("Watcher closed in namespace {}", (Object)AbstractWatcher.this.namespace);
                    }
                }
            });
            return watch;
        }, Entrypoint.EXECUTORS);
        ((CompletableFuture)cf.thenApply(w -> {
            log.info("CustomResource watcher running for kinds {}", (Object)this.entityName);
            return w;
        })).exceptionally(e -> {
            log.error("CustomResource watcher failed to start", e.getCause());
            return null;
        });
        return cf;
    }

    private void recreateWatcher() {
        this.watch.close();
        CompletableFuture<Watch> configMapWatch = this.isCrd ? this.createCustomResourceWatch() : this.createConfigMapWatch();
        String crdOrCm = this.isCrd ? "CustomResource" : "ConfigMap";
        ((CompletableFuture)configMapWatch.thenApply(res -> {
            log.info("{} watch recreated in namespace {}", (Object)crdOrCm, (Object)this.namespace);
            this.watch = res;
            return res;
        })).exceptionally(e -> {
            log.error("Failed to recreate {} watch in namespace {}", (Object)crdOrCm, (Object)this.namespace);
            return null;
        });
    }

    private void handleAction(Watcher.Action action, T entity, String ns) {
        if (!this.fullReconciliationRun) {
            return;
        }
        String name = ((EntityInfo)entity).getName();
        try {
            switch (action) {
                case ADDED: {
                    log.info("{}creating{} {}:  \n{}\n", new Object[]{AnsiColors.gr(), AnsiColors.xx(), this.entityName, name});
                    this.onAdd.accept(entity, ns);
                    log.info("{} {} has been  {}created{}", new Object[]{this.entityName, name, AnsiColors.gr(), AnsiColors.xx()});
                    break;
                }
                case DELETED: {
                    log.info("{}deleting{} {}:  \n{}\n", new Object[]{AnsiColors.gr(), AnsiColors.xx(), this.entityName, name});
                    this.onDelete.accept(entity, ns);
                    log.info("{} {} has been  {}deleted{}", new Object[]{this.entityName, name, AnsiColors.gr(), AnsiColors.xx()});
                    break;
                }
                case MODIFIED: {
                    log.info("{}modifying{} {}:  \n{}\n", new Object[]{AnsiColors.gr(), AnsiColors.xx(), this.entityName, name});
                    this.onModify.accept(entity, ns);
                    log.info("{} {} has been  {}modified{}", new Object[]{this.entityName, name, AnsiColors.gr(), AnsiColors.xx()});
                    break;
                }
                default: {
                    log.error("Unknown action: {} in namespace {}", (Object)action, (Object)this.namespace);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.warn("{}Error{} when reacting on event, cause: {}", new Object[]{AnsiColors.re(), AnsiColors.xx(), e.getMessage()});
            e.printStackTrace();
        }
    }

    public void close() {
        log.info("Stopping {} for namespace {}", (Object)(this.isCrd ? "CustomResourceWatch" : "ConfigMapWatch"), (Object)this.namespace);
        this.watch.close();
        this.client.close();
    }

    public void setFullReconciliationRun(boolean fullReconciliationRun) {
        this.fullReconciliationRun = fullReconciliationRun;
    }
}

