/*
 * Decompiled with CFR 0.152.
 */
package io.radanalytics.operator.common;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OperatorConfig {
    public static final String WATCHED_NAMESPACE = "WATCHED_NAMESPACE";
    public static final String METRICS = "METRICS";
    public static final String METRICS_JVM = "METRICS_JVM";
    public static final String METRICS_PORT = "METRICS_PORT";
    public static final String FULL_RECONCILIATION_INTERVAL_S = "FULL_RECONCILIATION_INTERVAL_S";
    public static final String OPERATOR_OPERATION_TIMEOUT_MS = "OPERATOR_OPERATION_TIMEOUT_MS";
    public static final boolean DEFAULT_METRICS = false;
    public static final boolean DEFAULT_METRICS_JVM = false;
    public static final int DEFAULT_METRICS_PORT = 8080;
    public static final long DEFAULT_FULL_RECONCILIATION_INTERVAL_S = 180L;
    public static final long DEFAULT_OPERATION_TIMEOUT_MS = 60000L;
    private final Set<String> namespaces;
    private final boolean metrics;
    private final boolean metricsJvm;
    private final int metricsPort;
    private final long reconciliationIntervalS;
    private final long operationTimeoutMs;

    public OperatorConfig(Set<String> namespaces, boolean metrics, boolean metricsJvm, int metricsPort, long reconciliationIntervalS, long operationTimeoutMs) {
        this.namespaces = namespaces;
        this.reconciliationIntervalS = reconciliationIntervalS;
        this.operationTimeoutMs = operationTimeoutMs;
        this.metrics = metrics;
        this.metricsJvm = metricsJvm;
        this.metricsPort = metricsPort;
    }

    public static OperatorConfig fromMap(Map<String, String> map) {
        String namespacesList = map.get(WATCHED_NAMESPACE);
        HashSet<String> namespaces = namespacesList == null || namespacesList.isEmpty() ? null : new HashSet<String>(Arrays.asList(namespacesList.trim().split("\\s*,+\\s*")));
        boolean metricsAux = false;
        String metricsEnvVar = map.get(METRICS);
        if (metricsEnvVar != null) {
            metricsAux = "true".equals(metricsEnvVar.trim().toLowerCase());
        }
        boolean metricsJvmAux = false;
        int metricsPortAux = 8080;
        if (metricsAux) {
            String metricsPortEnvVar;
            String metricsJvmEnvVar = map.get(METRICS_JVM);
            if (metricsJvmEnvVar != null) {
                metricsJvmAux = "true".equals(metricsJvmEnvVar.trim().toLowerCase());
            }
            if ((metricsPortEnvVar = map.get(METRICS_PORT)) != null) {
                metricsPortAux = Integer.parseInt(metricsPortEnvVar.trim().toLowerCase());
            }
        }
        long reconciliationInterval = 180L;
        String reconciliationIntervalEnvVar = map.get(FULL_RECONCILIATION_INTERVAL_S);
        if (reconciliationIntervalEnvVar != null) {
            reconciliationInterval = Long.parseLong(reconciliationIntervalEnvVar);
        }
        long operationTimeout = 60000L;
        String operationTimeoutEnvVar = map.get(OPERATOR_OPERATION_TIMEOUT_MS);
        if (operationTimeoutEnvVar != null) {
            operationTimeout = Long.parseLong(operationTimeoutEnvVar);
        }
        return new OperatorConfig(namespaces, metricsAux, metricsJvmAux, metricsPortAux, reconciliationInterval, operationTimeout);
    }

    public Set<String> getNamespaces() {
        return this.namespaces;
    }

    public long getReconciliationIntervalS() {
        return this.reconciliationIntervalS;
    }

    public long getOperationTimeoutMs() {
        return this.operationTimeoutMs;
    }

    public boolean isMetrics() {
        return this.metrics;
    }

    public boolean isMetricsJvm() {
        return this.metricsJvm;
    }

    public int getMetricsPort() {
        return this.metricsPort;
    }

    public String toString() {
        return "OperatorConfig{namespaces=" + this.namespaces + ", metrics=" + this.metrics + ", metricsJvm=" + this.metricsJvm + ", metricsPort=" + this.metricsPort + ", reconciliationIntervalS=" + this.reconciliationIntervalS + ", operationTimeoutMs=" + this.operationTimeoutMs + '}';
    }
}

