/*
 * Decompiled with CFR 0.152.
 */
package io.radanalytics.operator.common;

import io.radanalytics.operator.common.AbstractOperator;
import io.radanalytics.operator.common.AnsiColors;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessRunner {
    private static final Logger log = LoggerFactory.getLogger((String)AbstractOperator.class.getName());

    public static void runPythonScript(String path) {
        ProcessRunner.runCommand("python3 " + path);
    }

    public static void runShellScript(String path) {
        ProcessRunner.runCommand(path);
    }

    public static void runCommand(String command) {
        try {
            String line;
            Object[] commands = new String[]{"sh", "-c", "\"" + command + "\""};
            log.info("running: {}", (Object)Arrays.toString(commands));
            Process p = Runtime.getRuntime().exec((String[])commands);
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                sb.append(line + "\n");
            }
            String stdOutput = sb.toString();
            if (!stdOutput.isEmpty()) {
                log.info("{}{}{}", new Object[]{AnsiColors.gr(), stdOutput, AnsiColors.xx()});
            }
            in.close();
            sb = new StringBuilder();
            while ((line = err.readLine()) != null) {
                sb.append(line + "\n");
            }
            String errOutput = sb.toString();
            if (!errOutput.isEmpty()) {
                log.error("{}{}{}", new Object[]{AnsiColors.re(), stdOutput, AnsiColors.xx()});
            }
            err.close();
        }
        catch (IOException e) {
            log.error("Running '{}' failed with: {}", (Object)command, (Object)e.getMessage());
            e.printStackTrace();
        }
    }
}

