/*
 * Decompiled with CFR 0.152.
 */
package io.radanalytics.operator.resource;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.radanalytics.operator.common.EntityInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;

public class HasDataHelper {
    private static final Logger log = LoggerFactory.getLogger((String)HasDataHelper.class.getName());

    public static <T extends EntityInfo> T parseYaml(Class<T> clazz, String yamlDoc, String name) {
        LoaderOptions options = new LoaderOptions();
        Yaml snake = new Yaml((BaseConstructor)new Constructor(clazz));
        EntityInfo entity = null;
        try {
            entity = (EntityInfo)snake.load(yamlDoc);
        }
        catch (YAMLException ex) {
            String msg = "Unable to parse yaml definition of configmap, check if you don't have typo: \n'\n" + yamlDoc + "\n'\n";
            log.error(msg);
            throw new IllegalStateException(ex);
        }
        if (entity == null) {
            String msg = "Unable to parse yaml definition of configmap, check if you don't have typo: \n'\n" + yamlDoc + "\n'\n";
            log.error(msg);
            try {
                entity = (EntityInfo)clazz.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (entity != null && entity.getName() == null) {
            entity.setName(name);
        }
        return (T)entity;
    }

    public static <T extends EntityInfo> T parseCM(Class<T> clazz, ConfigMap cm) {
        String yaml = (String)cm.getData().get("config");
        T entity = HasDataHelper.parseYaml(clazz, yaml, cm.getMetadata().getName());
        return entity;
    }
}

