/*
 * Decompiled with CFR 0.152.
 */
package io.radanalytics.operator.resource;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class LabelsHelper {
    public static final String OPERATOR_KIND_LABEL = "kind";
    public static final String OPERATOR_SEVICE_TYPE_LABEL = "service";
    public static final String OPERATOR_RC_TYPE_LABEL = "rcType";
    public static final String OPERATOR_POD_TYPE_LABEL = "podType";
    public static final String OPERATOR_DEPLOYMENT_LABEL = "deployment";

    public static final Optional<String> getKind(HasMetadata resource, String prefix) {
        return Optional.ofNullable(resource).map(r -> r.getMetadata()).map(m -> m.getLabels()).map(l -> (String)l.get(prefix + OPERATOR_KIND_LABEL));
    }

    public static Map<String, String> forKind(String kind, String prefix) {
        return Collections.singletonMap(prefix + OPERATOR_KIND_LABEL, kind);
    }
}

