/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall;

import io.rainfall.AssertionEvaluator;
import io.rainfall.Configuration;
import io.rainfall.Execution;
import io.rainfall.TestException;
import io.rainfall.statistics.StatisticsHolder;
import java.util.List;
import java.util.Map;

public abstract class Operation {
    private volatile Execution.ExecutionState state = Execution.ExecutionState.UNKNOWN;
    private float weight = 1.0f;

    public abstract void exec(StatisticsHolder var1, Map<Class<? extends Configuration>, Configuration> var2, List<AssertionEvaluator> var3) throws TestException;

    public Operation withWeight(Double weight) {
        this.weight = weight.floatValue();
        return this;
    }

    public float getWeight() {
        return this.weight;
    }

    protected long getTimeInNs() {
        return System.nanoTime();
    }

    public Execution.ExecutionState getExecutionState() {
        return this.state;
    }

    public void markExecutionState(Execution.ExecutionState state) {
        this.state = state;
    }
}

