/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall;

import io.rainfall.Assertion;
import io.rainfall.AssertionEvaluator;
import io.rainfall.Configuration;
import io.rainfall.Execution;
import io.rainfall.Operation;
import io.rainfall.Scenario;
import io.rainfall.SyntaxException;
import io.rainfall.TestException;
import io.rainfall.configuration.ConcurrencyConfig;
import io.rainfall.configuration.ReportingConfig;
import io.rainfall.statistics.InitStatisticsHolder;
import io.rainfall.statistics.RuntimeStatisticsHolder;
import io.rainfall.statistics.StatisticsPeekHolder;
import io.rainfall.statistics.StatisticsThread;
import io.rainfall.utils.RangeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class ScenarioRun<E extends Enum<E>> {
    private Scenario scenario;
    private Map<Class<? extends Configuration>, Configuration> configurations = new ConcurrentHashMap<Class<? extends Configuration>, Configuration>();
    private List<AssertionEvaluator> assertions = new ArrayList<AssertionEvaluator>();
    private Execution warmup = null;
    private List<Execution> executions = null;
    private RuntimeStatisticsHolder<E> statisticsHolder;

    public ScenarioRun(Scenario scenario) {
        this.scenario = scenario;
        this.initDefaultConfigurations();
    }

    private void initDefaultConfigurations() {
        this.configurations.put(ConcurrencyConfig.class, new ConcurrencyConfig());
    }

    public ScenarioRun warmup(Execution execution) throws SyntaxException {
        if (this.warmup != null) {
            throw new SyntaxException("Warmup is already defined.");
        }
        this.warmup = execution;
        return this;
    }

    public ScenarioRun executed(Execution ... executions) throws SyntaxException {
        if (this.executions != null) {
            throw new SyntaxException("Executions are already defined.");
        }
        this.executions = Arrays.asList(executions);
        return this;
    }

    public ScenarioRun config(Configuration ... configs) {
        for (Configuration config : configs) {
            this.configurations.put(config.getClass(), config);
        }
        return this;
    }

    public ScenarioRun assertion(Assertion actual, Assertion expected) {
        this.assertions.add(new AssertionEvaluator(actual, expected));
        return this;
    }

    public StatisticsPeekHolder<E> start() {
        long start = System.currentTimeMillis();
        ReportingConfig reportingConfig = (ReportingConfig)this.configurations.get(ReportingConfig.class);
        RuntimeStatisticsHolder blankStatisticsHolder = new RuntimeStatisticsHolder(reportingConfig.getResults(), reportingConfig.getResultsReported());
        this.initStatistics(blankStatisticsHolder);
        try {
            if (this.warmup != null) {
                System.out.println("Executing warmup phase, please wait.");
                this.warmup.execute(blankStatisticsHolder, this.scenario, this.configurations, this.assertions);
            }
        }
        catch (TestException e) {
            throw new RuntimeException(e);
        }
        this.statisticsHolder = new RuntimeStatisticsHolder(reportingConfig.getResults(), reportingConfig.getResultsReported());
        this.initStatistics(this.statisticsHolder);
        Timer timer = new Timer();
        StatisticsThread<E> stats = new StatisticsThread<E>(this.statisticsHolder, reportingConfig);
        TimeUnit reportIntervalUnit = reportingConfig.getReportTimeUnit();
        long reportIntervalMillis = reportIntervalUnit.toMillis(reportingConfig.getReportInterval());
        timer.scheduleAtFixedRate(stats, reportIntervalMillis, reportIntervalMillis);
        try {
            for (Execution execution : this.executions) {
                execution.execute(this.statisticsHolder, this.scenario, this.configurations, this.assertions);
            }
        }
        catch (TestException e) {
            throw new RuntimeException(e);
        }
        StatisticsPeekHolder<E> peek = stats.stop();
        long end = System.currentTimeMillis();
        return peek;
    }

    private void initStatistics(RuntimeStatisticsHolder<E> statisticsHolder) {
        try {
            List<RangeMap<Operation>> operations = this.scenario.getOperations();
            for (RangeMap<Operation> operation : operations) {
                Collection<Operation> allOperations = operation.getAll();
                for (Operation allOperation : allOperations) {
                    allOperation.exec(new InitStatisticsHolder<E>(statisticsHolder), this.configurations, this.assertions);
                }
            }
        }
        catch (TestException e) {
            throw new RuntimeException(e);
        }
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public Configuration getConfiguration(Class configurationClass) {
        return this.configurations.get(configurationClass);
    }

    public List<AssertionEvaluator> getAssertions() {
        return this.assertions;
    }
}

