/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.configuration;

import io.rainfall.Configuration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ConcurrencyConfig
extends Configuration {
    private int nbThreads = 1;
    private final Map<Integer, AtomicInteger> nbIterationsPerThread = new HashMap<Integer, AtomicInteger>();
    private long timeoutInSeconds = 600L;

    public static ConcurrencyConfig concurrencyConfig() {
        return new ConcurrencyConfig();
    }

    public ConcurrencyConfig threads(int nbThreads) {
        this.nbThreads = nbThreads;
        return this;
    }

    public ConcurrencyConfig timeout(int nb, TimeUnit unit) {
        this.timeoutInSeconds = unit.toSeconds(nb);
        return this;
    }

    public int getNbThreads() {
        return this.nbThreads;
    }

    public long getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNbIterationsForThread(int threadNb, long nbIterations) {
        Map<Integer, AtomicInteger> map = this.nbIterationsPerThread;
        synchronized (map) {
            if (this.nbIterationsPerThread.size() == 0) {
                int i;
                for (i = 0; i < this.nbThreads; ++i) {
                    this.nbIterationsPerThread.put(i, new AtomicInteger());
                }
                i = 0;
                while (nbIterations > 0L) {
                    this.nbIterationsPerThread.get(i % this.nbThreads).incrementAndGet();
                    ++i;
                    --nbIterations;
                }
            }
        }
        return this.nbIterationsPerThread.get(threadNb).intValue();
    }
}

