/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.configuration;

import io.rainfall.Configuration;
import io.rainfall.Reporter;
import io.rainfall.reporting.HtmlReporter;
import io.rainfall.reporting.TextReporter;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ReportingConfig<E extends Enum<E>>
extends Configuration {
    private Enum<E>[] results;
    private Enum<E>[] resultsReported;
    private long reportInterval = 1000L;
    private TimeUnit reportIntervalUnit = TimeUnit.MILLISECONDS;
    private final Set<Reporter<E>> logReporters = new HashSet<Reporter<E>>();

    public ReportingConfig(Enum<E>[] results, Enum<E>[] resultsReported) {
        this.results = results;
        this.resultsReported = resultsReported;
    }

    public static <E extends Enum<E>> ReportingConfig<E> report(Class<E> results) {
        return new ReportingConfig<E>((Enum[])results.getEnumConstants(), (Enum[])results.getEnumConstants());
    }

    public static <E extends Enum<E>> ReportingConfig<E> report(Class<E> results, Enum<E>[] resultsReported) {
        return new ReportingConfig<E>((Enum[])results.getEnumConstants(), resultsReported);
    }

    public ReportingConfig every(long amount, TimeUnit unit) {
        this.reportInterval = amount;
        this.reportIntervalUnit = unit;
        return this;
    }

    public ReportingConfig log(Reporter ... reporters) {
        for (Reporter reporter : reporters) {
            this.logReporters.add(reporter);
        }
        return this;
    }

    public static Reporter text() {
        return new TextReporter();
    }

    public static Reporter html(String outputPath) {
        return new HtmlReporter(outputPath);
    }

    public static Reporter html() {
        return new HtmlReporter();
    }

    public Enum<E>[] getResults() {
        return this.results;
    }

    public Enum<E>[] getResultsReported() {
        return this.resultsReported;
    }

    public Set<Reporter<E>> getLogReporters() {
        return this.logReporters;
    }

    public long getReportInterval() {
        return this.reportInterval;
    }

    public TimeUnit getReportTimeUnit() {
        return this.reportIntervalUnit;
    }
}

