/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.execution;

import io.rainfall.AssertionEvaluator;
import io.rainfall.Configuration;
import io.rainfall.Execution;
import io.rainfall.Operation;
import io.rainfall.Scenario;
import io.rainfall.TestException;
import io.rainfall.Unit;
import io.rainfall.configuration.ConcurrencyConfig;
import io.rainfall.statistics.StatisticsHolder;
import io.rainfall.unit.Every;
import io.rainfall.unit.TimeMeasurement;
import io.rainfall.utils.RangeMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicLong;

public class InParallel
extends Execution {
    protected static AtomicLong THREAD_NUMBER_GENERATOR = new AtomicLong(0L);
    protected final int nb;
    protected final Unit unit;
    protected final Every every;
    protected final TimeMeasurement during;

    public InParallel(int nb, Unit unit, Every every, TimeMeasurement during) {
        this.nb = nb;
        this.unit = unit;
        this.every = every;
        this.during = during;
    }

    @Override
    public <E extends Enum<E>> void execute(final StatisticsHolder<E> statisticsHolder, final Scenario scenario, final Map<Class<? extends Configuration>, Configuration> configurations, final List<AssertionEvaluator> assertions) throws TestException {
        ConcurrencyConfig concurrencyConfig = (ConcurrencyConfig)configurations.get(ConcurrencyConfig.class);
        int nbThreads = concurrencyConfig.getNbThreads();
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(concurrencyConfig.getNbThreads());
        final ArrayList exceptions = new ArrayList();
        this.markExecutionState(scenario, Execution.ExecutionState.BEGINNING);
        for (int threadNb = 0; threadNb < nbThreads; ++threadNb) {
            final int max = concurrencyConfig.getNbIterationsForThread(threadNb, this.nb);
            final ScheduledFuture<?> future = scheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setName("Rainfall-core Operations Thread - " + THREAD_NUMBER_GENERATOR.getAndIncrement());
                    try {
                        for (int i = 0; i < max; ++i) {
                            List<RangeMap<Operation>> operations = scenario.getOperations();
                            for (RangeMap<Operation> operation : operations) {
                                operation.get(InParallel.this.weightRnd.nextFloat(operation.getHigherBound().floatValue())).exec(statisticsHolder, configurations, assertions);
                            }
                        }
                    }
                    catch (TestException e) {
                        e.printStackTrace();
                        exceptions.add(new TestException(e));
                    }
                }
            }, 0L, this.every.getNb(), this.every.getTimeDivision().getTimeUnit());
            scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    InParallel.this.markExecutionState(scenario, Execution.ExecutionState.ENDING);
                    future.cancel(true);
                }
            }, (long)this.during.getNb(), this.during.getTimeDivision().getTimeUnit());
            try {
                future.get();
                continue;
            }
            catch (CancellationException e) {
                continue;
            }
            catch (InterruptedException e) {
                throw new TestException(e);
            }
            catch (ExecutionException e) {
                throw new TestException(e);
            }
        }
        this.markExecutionState(scenario, Execution.ExecutionState.ENDING);
        scheduler.shutdown();
        if (exceptions.size() > 0) {
            throw (TestException)exceptions.get(0);
        }
    }
}

