/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.execution;

import io.rainfall.AssertionEvaluator;
import io.rainfall.Configuration;
import io.rainfall.Execution;
import io.rainfall.Operation;
import io.rainfall.Scenario;
import io.rainfall.TestException;
import io.rainfall.configuration.ConcurrencyConfig;
import io.rainfall.statistics.StatisticsHolder;
import io.rainfall.unit.Every;
import io.rainfall.unit.From;
import io.rainfall.unit.Over;
import io.rainfall.unit.To;
import io.rainfall.utils.RangeMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import jsr166e.extra.AtomicDouble;

public class Ramp
extends Execution {
    private final From from;
    private final To to;
    private final Every every;
    private final Over over;

    public Ramp(From from, To to, Every every, Over over) {
        this.from = from;
        this.to = to;
        this.every = every;
        this.over = over;
    }

    @Override
    public <E extends Enum<E>> void execute(final StatisticsHolder<E> statisticsHolder, final Scenario scenario, final Map<Class<? extends Configuration>, Configuration> configurations, final List<AssertionEvaluator> assertions) throws TestException {
        final ConcurrencyConfig concurrencyConfig = (ConcurrencyConfig)configurations.get(ConcurrencyConfig.class);
        int nbThreads = concurrencyConfig.getNbThreads();
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(concurrencyConfig.getNbThreads());
        final ArrayList exceptions = new ArrayList();
        this.markExecutionState(scenario, Execution.ExecutionState.BEGINNING);
        final AtomicDouble nb = new AtomicDouble(this.from.getNb());
        final Double increment = (double)(this.to.getNb() - this.from.getNb()) / (this.over.getNbInMs() / this.every.getNbInMs());
        for (int threadNb = 0; threadNb < nbThreads; ++threadNb) {
            final int finalThreadNb = threadNb;
            final ScheduledFuture<?> future = scheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setName("Rainfall-core Operations Thread");
                    System.out.println(" ramping users = " + nb.longValue() + " /" + nb.get());
                    int max = concurrencyConfig.getNbIterationsForThread(finalThreadNb, nb.longValue());
                    nb.addAndGet(increment);
                    try {
                        for (int i = 0; i < max; ++i) {
                            List<RangeMap<Operation>> operations = scenario.getOperations();
                            for (RangeMap<Operation> operation : operations) {
                                operation.get(Ramp.this.weightRnd.nextFloat(operation.getHigherBound().floatValue())).exec(statisticsHolder, configurations, assertions);
                            }
                        }
                    }
                    catch (TestException e) {
                        e.printStackTrace();
                        exceptions.add(new TestException(e));
                    }
                }
            }, 0L, this.every.getNb(), this.every.getTimeDivision().getTimeUnit());
            scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    Ramp.this.markExecutionState(scenario, Execution.ExecutionState.ENDING);
                    future.cancel(true);
                }
            }, (long)this.over.getNb(), this.over.getTimeDivision().getTimeUnit());
            try {
                future.get();
                continue;
            }
            catch (CancellationException e) {
                continue;
            }
            catch (InterruptedException e) {
                throw new TestException(e);
            }
            catch (ExecutionException e) {
                throw new TestException(e);
            }
        }
        this.markExecutionState(scenario, Execution.ExecutionState.ENDING);
        scheduler.shutdown();
        if (exceptions.size() > 0) {
            throw (TestException)exceptions.get(0);
        }
    }
}

