/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.execution;

import io.rainfall.AssertionEvaluator;
import io.rainfall.Configuration;
import io.rainfall.Execution;
import io.rainfall.Operation;
import io.rainfall.Scenario;
import io.rainfall.TestException;
import io.rainfall.configuration.ConcurrencyConfig;
import io.rainfall.statistics.StatisticsHolder;
import io.rainfall.unit.Over;
import io.rainfall.unit.TimeDivision;
import io.rainfall.utils.RangeMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class RunsDuring
extends Execution {
    private final Over during;

    public RunsDuring(int nb, TimeDivision timeDivision) {
        this.during = new Over(nb, timeDivision);
    }

    @Override
    public <E extends Enum<E>> void execute(final StatisticsHolder<E> statisticsHolder, final Scenario scenario, final Map<Class<? extends Configuration>, Configuration> configurations, final List<AssertionEvaluator> assertions) throws TestException {
        ConcurrencyConfig concurrencyConfig = (ConcurrencyConfig)configurations.get(ConcurrencyConfig.class);
        int nbThreads = concurrencyConfig.getNbThreads();
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(concurrencyConfig.getNbThreads());
        final ExecutorService executor = Executors.newFixedThreadPool(nbThreads);
        this.markExecutionState(scenario, Execution.ExecutionState.BEGINNING);
        final AtomicBoolean doneFlag = new AtomicBoolean(false);
        ArrayList<Future> futures = new ArrayList<Future>();
        for (int threadNb = 0; threadNb < nbThreads; ++threadNb) {
            Future future = executor.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Thread.currentThread().setName("Rainfall-core Operations Thread");
                    List<RangeMap<Operation>> operations = scenario.getOperations();
                    while (!Thread.currentThread().isInterrupted() && !doneFlag.get()) {
                        for (RangeMap<Operation> operation : operations) {
                            operation.get(RunsDuring.this.weightRnd.nextFloat(operation.getHigherBound().floatValue())).exec(statisticsHolder, configurations, assertions);
                        }
                    }
                    return null;
                }
            });
            futures.add(future);
        }
        scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                RunsDuring.this.markExecutionState(scenario, Execution.ExecutionState.ENDING);
                RunsDuring.this.shutdownNicely(doneFlag, executor);
            }
        }, (long)this.during.getNb(), this.during.getTimeDivision().getTimeUnit());
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException e) {
            this.markExecutionState(scenario, Execution.ExecutionState.ENDING);
            this.shutdownNicely(doneFlag, executor);
            throw new TestException("Thread execution Interruption", e);
        }
        catch (ExecutionException e) {
            this.markExecutionState(scenario, Execution.ExecutionState.ENDING);
            this.shutdownNicely(doneFlag, executor);
            throw new TestException("Thread execution error", e);
        }
        try {
            long timeoutInSeconds = ((ConcurrencyConfig)configurations.get(ConcurrencyConfig.class)).getTimeoutInSeconds();
            boolean success = executor.awaitTermination(timeoutInSeconds, TimeUnit.SECONDS);
            if (!success) {
                throw new TestException("Execution of Scenario timed out after " + timeoutInSeconds + " seconds.");
            }
        }
        catch (InterruptedException e) {
            throw new TestException("Execution of Scenario didn't stop correctly.", e);
        }
    }

    private void shutdownNicely(AtomicBoolean doneFlag, ExecutorService executor) {
        doneFlag.set(true);
        executor.shutdown();
    }
}

