/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.generator;

import io.rainfall.ObjectGenerator;

public class StringGenerator
implements ObjectGenerator<String> {
    private final String padding;
    private int length;

    public StringGenerator(int length) {
        this.length = length;
        if (length <= 0) {
            throw new IllegalStateException("Can not generate a String with a length less or equal to 0");
        }
        StringBuffer outputBuffer = new StringBuffer(length);
        for (int i = 0; i < length - 1; ++i) {
            outputBuffer.append("0");
        }
        this.padding = outputBuffer.toString();
    }

    @Override
    public String generate(Long seed) {
        String s = this.padding + seed;
        return s.substring(s.length() - this.length);
    }

    public static ObjectGenerator<String> fixedLength(int length) {
        return new StringGenerator(length);
    }
}

