/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.generator.sequence;

import io.rainfall.utils.ConcurrentPseudoRandom;

public enum Distribution {
    FLAT{

        @Override
        public long generate(ConcurrentPseudoRandom rnd, long minimum, long maximum, long width) {
            return Math.abs(rnd.nextLong()) % (maximum - minimum) + minimum;
        }
    }
    ,
    GAUSSIAN{

        @Override
        public long generate(ConcurrentPseudoRandom rnd, long minimum, long maximum, long width) {
            long candidate;
            float y;
            float x;
            double r;
            long center = minimum + (maximum - minimum) / 2L;
            double stdDev = width;
            while ((r = (double)((x = 2.0f * rnd.nextFloat() - 1.0f) * x + (y = 2.0f * rnd.nextFloat() - 1.0f) * y)) == 0.0 || r > 1.0 || (candidate = (long)((double)x * (r = Math.sqrt(-2.0 * Math.log(r) / r)) * (double)width + (double)center)) < minimum || candidate >= maximum) {
            }
            return candidate;
        }
    };


    public abstract long generate(ConcurrentPseudoRandom var1, long var2, long var4, long var6);
}

