/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.reporting;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

public class GcStatsCollector {
    private static final String GARBAGE_COLLECTION_NOTIFICATION = "com.sun.management.gc.notification";
    private final Queue<GcStats> gcStatsQueue = new ConcurrentLinkedQueue<GcStats>();
    private final NotificationListener listener = new NotificationListener(){

        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (notification.getType().equals(GcStatsCollector.GARBAGE_COLLECTION_NOTIFICATION)) {
                CompositeData userData = (CompositeData)notification.getUserData();
                CompositeData gcInfo = (CompositeData)userData.get("gcInfo");
                GcStats gcStats = new GcStats((Long)gcInfo.get("duration"), (String)userData.get("gcAction"), (Long)gcInfo.get("startTime"), (String)userData.get("gcCause"), (String)userData.get("gcName"));
                GcStatsCollector.this.gcStatsQueue.add(gcStats);
            }
        }
    };

    public List<GcStats> drain() {
        GcStats gcStats;
        ArrayList<GcStats> result = new ArrayList<GcStats>();
        while ((gcStats = this.gcStatsQueue.poll()) != null) {
            result.add(gcStats);
        }
        return result;
    }

    public void registerGcEventListeners() {
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcMxBean : gcMxBeans) {
            NotificationEmitter emitter = (NotificationEmitter)((Object)gcMxBean);
            emitter.addNotificationListener(this.listener, null, null);
        }
    }

    public void unregisterGcEventListeners() {
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcMxBean : gcMxBeans) {
            NotificationEmitter emitter = (NotificationEmitter)((Object)gcMxBean);
            try {
                emitter.removeNotificationListener(this.listener);
            }
            catch (ListenerNotFoundException e) {}
        }
    }

    public static class GcStats {
        private final long startTimestamp;
        private final long duration;
        private final String action;
        private final String cause;
        private final String name;

        public GcStats(long duration, String action, long startTimestamp, String cause, String name) {
            this.duration = duration;
            this.action = action;
            this.startTimestamp = startTimestamp;
            this.cause = cause;
            this.name = name;
        }

        public long getStartTimestamp() {
            return this.startTimestamp;
        }

        public long getDuration() {
            return this.duration;
        }

        public String getAction() {
            return this.action;
        }

        public String getCause() {
            return this.cause;
        }

        public String getName() {
            return this.name;
        }

        public static enum Header {
            DURATION,
            ACTION,
            CAUSE,
            NAME;

        }
    }
}

